/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SubvolumeModelProperties
implements JsonSerializable<SubvolumeModelProperties> {
    private String path;
    private String parentPath;
    private Long size;
    private Long bytesUsed;
    private String permissions;
    private OffsetDateTime creationTimestamp;
    private OffsetDateTime accessedTimestamp;
    private OffsetDateTime modifiedTimestamp;
    private OffsetDateTime changedTimestamp;
    private String provisioningState;

    public String path() {
        return this.path;
    }

    public SubvolumeModelProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public String parentPath() {
        return this.parentPath;
    }

    public SubvolumeModelProperties withParentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    public Long size() {
        return this.size;
    }

    public SubvolumeModelProperties withSize(Long size) {
        this.size = size;
        return this;
    }

    public Long bytesUsed() {
        return this.bytesUsed;
    }

    public SubvolumeModelProperties withBytesUsed(Long bytesUsed) {
        this.bytesUsed = bytesUsed;
        return this;
    }

    public String permissions() {
        return this.permissions;
    }

    public SubvolumeModelProperties withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public OffsetDateTime creationTimestamp() {
        return this.creationTimestamp;
    }

    public SubvolumeModelProperties withCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public OffsetDateTime accessedTimestamp() {
        return this.accessedTimestamp;
    }

    public SubvolumeModelProperties withAccessedTimestamp(OffsetDateTime accessedTimestamp) {
        this.accessedTimestamp = accessedTimestamp;
        return this;
    }

    public OffsetDateTime modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public SubvolumeModelProperties withModifiedTimestamp(OffsetDateTime modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
        return this;
    }

    public OffsetDateTime changedTimestamp() {
        return this.changedTimestamp;
    }

    public SubvolumeModelProperties withChangedTimestamp(OffsetDateTime changedTimestamp) {
        this.changedTimestamp = changedTimestamp;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public SubvolumeModelProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("parentPath", this.parentPath);
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeNumberField("bytesUsed", (Number)this.bytesUsed);
        jsonWriter.writeStringField("permissions", this.permissions);
        jsonWriter.writeStringField("creationTimeStamp", this.creationTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTimestamp));
        jsonWriter.writeStringField("accessedTimeStamp", this.accessedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedTimestamp));
        jsonWriter.writeStringField("modifiedTimeStamp", this.modifiedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTimestamp));
        jsonWriter.writeStringField("changedTimeStamp", this.changedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.changedTimestamp));
        jsonWriter.writeStringField("provisioningState", this.provisioningState);
        return jsonWriter.writeEndObject();
    }

    public static SubvolumeModelProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubvolumeModelProperties)jsonReader.readObject(reader -> {
            SubvolumeModelProperties deserializedSubvolumeModelProperties = new SubvolumeModelProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.path = reader.getString();
                    continue;
                }
                if ("parentPath".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.parentPath = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("bytesUsed".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.bytesUsed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.permissions = reader.getString();
                    continue;
                }
                if ("creationTimeStamp".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.creationTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("accessedTimeStamp".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.accessedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("modifiedTimeStamp".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.modifiedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("changedTimeStamp".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.changedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSubvolumeModelProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubvolumeModelProperties;
        });
    }
}

