/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.BackupType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BackupProperties
implements JsonSerializable<BackupProperties> {
    private String backupId;
    private OffsetDateTime creationDate;
    private OffsetDateTime snapshotCreationDate;
    private OffsetDateTime completionDate;
    private String provisioningState;
    private Long size;
    private String label;
    private BackupType backupType;
    private String failureReason;
    private String volumeResourceId;
    private Boolean useExistingSnapshot;
    private String snapshotName;
    private String backupPolicyResourceId;
    private Boolean isLargeVolume;
    private static final ClientLogger LOGGER = new ClientLogger(BackupProperties.class);

    public String backupId() {
        return this.backupId;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public OffsetDateTime snapshotCreationDate() {
        return this.snapshotCreationDate;
    }

    public OffsetDateTime completionDate() {
        return this.completionDate;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Long size() {
        return this.size;
    }

    public String label() {
        return this.label;
    }

    public BackupProperties withLabel(String label) {
        this.label = label;
        return this;
    }

    public BackupType backupType() {
        return this.backupType;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String volumeResourceId() {
        return this.volumeResourceId;
    }

    public BackupProperties withVolumeResourceId(String volumeResourceId) {
        this.volumeResourceId = volumeResourceId;
        return this;
    }

    public Boolean useExistingSnapshot() {
        return this.useExistingSnapshot;
    }

    public BackupProperties withUseExistingSnapshot(Boolean useExistingSnapshot) {
        this.useExistingSnapshot = useExistingSnapshot;
        return this;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public BackupProperties withSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        return this;
    }

    public String backupPolicyResourceId() {
        return this.backupPolicyResourceId;
    }

    public Boolean isLargeVolume() {
        return this.isLargeVolume;
    }

    public void validate() {
        if (this.volumeResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property volumeResourceId in model BackupProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("volumeResourceId", this.volumeResourceId);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeBooleanField("useExistingSnapshot", this.useExistingSnapshot);
        jsonWriter.writeStringField("snapshotName", this.snapshotName);
        return jsonWriter.writeEndObject();
    }

    public static BackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackupProperties)jsonReader.readObject(reader -> {
            BackupProperties deserializedBackupProperties = new BackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("volumeResourceId".equals(fieldName)) {
                    deserializedBackupProperties.volumeResourceId = reader.getString();
                    continue;
                }
                if ("backupId".equals(fieldName)) {
                    deserializedBackupProperties.backupId = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedBackupProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("snapshotCreationDate".equals(fieldName)) {
                    deserializedBackupProperties.snapshotCreationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("completionDate".equals(fieldName)) {
                    deserializedBackupProperties.completionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBackupProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedBackupProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedBackupProperties.label = reader.getString();
                    continue;
                }
                if ("backupType".equals(fieldName)) {
                    deserializedBackupProperties.backupType = BackupType.fromString(reader.getString());
                    continue;
                }
                if ("failureReason".equals(fieldName)) {
                    deserializedBackupProperties.failureReason = reader.getString();
                    continue;
                }
                if ("useExistingSnapshot".equals(fieldName)) {
                    deserializedBackupProperties.useExistingSnapshot = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("snapshotName".equals(fieldName)) {
                    deserializedBackupProperties.snapshotName = reader.getString();
                    continue;
                }
                if ("backupPolicyResourceId".equals(fieldName)) {
                    deserializedBackupProperties.backupPolicyResourceId = reader.getString();
                    continue;
                }
                if ("isLargeVolume".equals(fieldName)) {
                    deserializedBackupProperties.isLargeVolume = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupProperties;
        });
    }
}

