/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRuleInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.Type;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRule;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRulePatch;
import java.util.Collections;
import java.util.Map;

public final class VolumeQuotaRuleImpl
implements VolumeQuotaRule,
VolumeQuotaRule.Definition,
VolumeQuotaRule.Update {
    private VolumeQuotaRuleInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private String volumeQuotaRuleName;
    private VolumeQuotaRulePatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Long quotaSizeInKiBs() {
        return this.innerModel().quotaSizeInKiBs();
    }

    @Override
    public Type quotaType() {
        return this.innerModel().quotaType();
    }

    @Override
    public String quotaTarget() {
        return this.innerModel().quotaTarget();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VolumeQuotaRuleInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeQuotaRuleImpl withExistingVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        this.volumeName = volumeName;
        return this;
    }

    @Override
    public VolumeQuotaRule create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeQuotaRules().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VolumeQuotaRule create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeQuotaRules().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, this.innerModel(), context);
        return this;
    }

    VolumeQuotaRuleImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new VolumeQuotaRuleInner();
        this.serviceManager = serviceManager;
        this.volumeQuotaRuleName = name;
    }

    @Override
    public VolumeQuotaRuleImpl update() {
        this.updateBody = new VolumeQuotaRulePatch();
        return this;
    }

    @Override
    public VolumeQuotaRule apply() {
        this.innerObject = this.serviceManager.serviceClient().getVolumeQuotaRules().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public VolumeQuotaRule apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumeQuotaRules().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, this.updateBody, context);
        return this;
    }

    VolumeQuotaRuleImpl(VolumeQuotaRuleInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
        this.volumeQuotaRuleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumeQuotaRules");
    }

    @Override
    public VolumeQuotaRule refresh() {
        this.innerObject = (VolumeQuotaRuleInner)((Object)this.serviceManager.serviceClient().getVolumeQuotaRules().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VolumeQuotaRule refresh(Context context) {
        this.innerObject = (VolumeQuotaRuleInner)((Object)this.serviceManager.serviceClient().getVolumeQuotaRules().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.volumeQuotaRuleName, context).getValue());
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withQuotaSizeInKiBs(Long quotaSizeInKiBs) {
        if (this.isInCreateMode()) {
            this.innerModel().withQuotaSizeInKiBs(quotaSizeInKiBs);
            return this;
        }
        this.updateBody.withQuotaSizeInKiBs(quotaSizeInKiBs);
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withQuotaType(Type quotaType) {
        this.innerModel().withQuotaType(quotaType);
        return this;
    }

    @Override
    public VolumeQuotaRuleImpl withQuotaTarget(String quotaTarget) {
        this.innerModel().withQuotaTarget(quotaTarget);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

