/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.MountTargetProperties;
import com.azure.resourcemanager.netapp.fluent.models.VolumeInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.AuthorizeRequest;
import com.azure.resourcemanager.netapp.models.AvsDataStore;
import com.azure.resourcemanager.netapp.models.BreakFileLocksRequest;
import com.azure.resourcemanager.netapp.models.BreakReplicationRequest;
import com.azure.resourcemanager.netapp.models.ClusterPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.EnableSubvolumes;
import com.azure.resourcemanager.netapp.models.EncryptionKeySource;
import com.azure.resourcemanager.netapp.models.FileAccessLogs;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserRequest;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserResponse;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import com.azure.resourcemanager.netapp.models.PeerClusterForVolumeMigrationRequest;
import com.azure.resourcemanager.netapp.models.PlacementKeyValuePairs;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import com.azure.resourcemanager.netapp.models.ReestablishReplicationRequest;
import com.azure.resourcemanager.netapp.models.RelocateVolumeRequest;
import com.azure.resourcemanager.netapp.models.Replication;
import com.azure.resourcemanager.netapp.models.SecurityStyle;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.SvmPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.Volume;
import com.azure.resourcemanager.netapp.models.VolumePatch;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumePropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumeRevert;
import com.azure.resourcemanager.netapp.models.VolumeStorageToNetworkProximity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class VolumeImpl
implements Volume,
Volume.Definition,
Volume.Update {
    private VolumeInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private VolumePatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String fileSystemId() {
        return this.innerModel().fileSystemId();
    }

    @Override
    public String creationToken() {
        return this.innerModel().creationToken();
    }

    @Override
    public ServiceLevel serviceLevel() {
        return this.innerModel().serviceLevel();
    }

    @Override
    public long usageThreshold() {
        return this.innerModel().usageThreshold();
    }

    @Override
    public VolumePropertiesExportPolicy exportPolicy() {
        return this.innerModel().exportPolicy();
    }

    @Override
    public List<String> protocolTypes() {
        List<String> inner = this.innerModel().protocolTypes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String snapshotId() {
        return this.innerModel().snapshotId();
    }

    @Override
    public Boolean deleteBaseSnapshot() {
        return this.innerModel().deleteBaseSnapshot();
    }

    @Override
    public String backupId() {
        return this.innerModel().backupId();
    }

    @Override
    public String baremetalTenantId() {
        return this.innerModel().baremetalTenantId();
    }

    @Override
    public String subnetId() {
        return this.innerModel().subnetId();
    }

    @Override
    public NetworkFeatures networkFeatures() {
        return this.innerModel().networkFeatures();
    }

    @Override
    public NetworkFeatures effectiveNetworkFeatures() {
        return this.innerModel().effectiveNetworkFeatures();
    }

    @Override
    public String networkSiblingSetId() {
        return this.innerModel().networkSiblingSetId();
    }

    @Override
    public VolumeStorageToNetworkProximity storageToNetworkProximity() {
        return this.innerModel().storageToNetworkProximity();
    }

    @Override
    public List<MountTargetProperties> mountTargets() {
        List<MountTargetProperties> inner = this.innerModel().mountTargets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String volumeType() {
        return this.innerModel().volumeType();
    }

    @Override
    public VolumePropertiesDataProtection dataProtection() {
        return this.innerModel().dataProtection();
    }

    @Override
    public Boolean isRestoring() {
        return this.innerModel().isRestoring();
    }

    @Override
    public Boolean snapshotDirectoryVisible() {
        return this.innerModel().snapshotDirectoryVisible();
    }

    @Override
    public Boolean kerberosEnabled() {
        return this.innerModel().kerberosEnabled();
    }

    @Override
    public SecurityStyle securityStyle() {
        return this.innerModel().securityStyle();
    }

    @Override
    public Boolean smbEncryption() {
        return this.innerModel().smbEncryption();
    }

    @Override
    public SmbAccessBasedEnumeration smbAccessBasedEnumeration() {
        return this.innerModel().smbAccessBasedEnumeration();
    }

    @Override
    public SmbNonBrowsable smbNonBrowsable() {
        return this.innerModel().smbNonBrowsable();
    }

    @Override
    public Boolean smbContinuouslyAvailable() {
        return this.innerModel().smbContinuouslyAvailable();
    }

    @Override
    public Float throughputMibps() {
        return this.innerModel().throughputMibps();
    }

    @Override
    public Float actualThroughputMibps() {
        return this.innerModel().actualThroughputMibps();
    }

    @Override
    public EncryptionKeySource encryptionKeySource() {
        return this.innerModel().encryptionKeySource();
    }

    @Override
    public String keyVaultPrivateEndpointResourceId() {
        return this.innerModel().keyVaultPrivateEndpointResourceId();
    }

    @Override
    public Boolean ldapEnabled() {
        return this.innerModel().ldapEnabled();
    }

    @Override
    public Boolean coolAccess() {
        return this.innerModel().coolAccess();
    }

    @Override
    public Integer coolnessPeriod() {
        return this.innerModel().coolnessPeriod();
    }

    @Override
    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy() {
        return this.innerModel().coolAccessRetrievalPolicy();
    }

    @Override
    public CoolAccessTieringPolicy coolAccessTieringPolicy() {
        return this.innerModel().coolAccessTieringPolicy();
    }

    @Override
    public String unixPermissions() {
        return this.innerModel().unixPermissions();
    }

    @Override
    public Integer cloneProgress() {
        return this.innerModel().cloneProgress();
    }

    @Override
    public FileAccessLogs fileAccessLogs() {
        return this.innerModel().fileAccessLogs();
    }

    @Override
    public AvsDataStore avsDataStore() {
        return this.innerModel().avsDataStore();
    }

    @Override
    public List<String> dataStoreResourceId() {
        List<String> inner = this.innerModel().dataStoreResourceId();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean isDefaultQuotaEnabled() {
        return this.innerModel().isDefaultQuotaEnabled();
    }

    @Override
    public Long defaultUserQuotaInKiBs() {
        return this.innerModel().defaultUserQuotaInKiBs();
    }

    @Override
    public Long defaultGroupQuotaInKiBs() {
        return this.innerModel().defaultGroupQuotaInKiBs();
    }

    @Override
    public Long maximumNumberOfFiles() {
        return this.innerModel().maximumNumberOfFiles();
    }

    @Override
    public String volumeGroupName() {
        return this.innerModel().volumeGroupName();
    }

    @Override
    public String capacityPoolResourceId() {
        return this.innerModel().capacityPoolResourceId();
    }

    @Override
    public String proximityPlacementGroup() {
        return this.innerModel().proximityPlacementGroup();
    }

    @Override
    public String t2Network() {
        return this.innerModel().t2Network();
    }

    @Override
    public String volumeSpecName() {
        return this.innerModel().volumeSpecName();
    }

    @Override
    public Boolean encrypted() {
        return this.innerModel().encrypted();
    }

    @Override
    public List<PlacementKeyValuePairs> placementRules() {
        List<PlacementKeyValuePairs> inner = this.innerModel().placementRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public EnableSubvolumes enableSubvolumes() {
        return this.innerModel().enableSubvolumes();
    }

    @Override
    public String provisionedAvailabilityZone() {
        return this.innerModel().provisionedAvailabilityZone();
    }

    @Override
    public Boolean isLargeVolume() {
        return this.innerModel().isLargeVolume();
    }

    @Override
    public String originatingResourceId() {
        return this.innerModel().originatingResourceId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VolumeInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl withExistingCapacityPool(String resourceGroupName, String accountName, String poolName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        return this;
    }

    @Override
    public Volume create() {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Volume create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.innerModel(), context);
        return this;
    }

    VolumeImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new VolumeInner();
        this.serviceManager = serviceManager;
        this.volumeName = name;
    }

    @Override
    public VolumeImpl update() {
        this.updateBody = new VolumePatch();
        return this;
    }

    @Override
    public Volume apply() {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public Volume apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.updateBody, context);
        return this;
    }

    VolumeImpl(VolumeInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
    }

    @Override
    public Volume refresh() {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Volume refresh(Context context) {
        this.innerObject = (VolumeInner)((Object)this.serviceManager.serviceClient().getVolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context).getValue());
        return this;
    }

    @Override
    public Volume populateAvailabilityZone() {
        return this.serviceManager.volumes().populateAvailabilityZone(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public Volume populateAvailabilityZone(Context context) {
        return this.serviceManager.volumes().populateAvailabilityZone(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void revert(VolumeRevert body) {
        this.serviceManager.volumes().revert(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public void revert(VolumeRevert body, Context context) {
        this.serviceManager.volumes().revert(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void resetCifsPassword() {
        this.serviceManager.volumes().resetCifsPassword(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void resetCifsPassword(Context context) {
        this.serviceManager.volumes().resetCifsPassword(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void breakFileLocks() {
        this.serviceManager.volumes().breakFileLocks(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void breakFileLocks(BreakFileLocksRequest body, Context context) {
        this.serviceManager.volumes().breakFileLocks(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(GetGroupIdListForLdapUserRequest body) {
        return this.serviceManager.volumes().listGetGroupIdListForLdapUser(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(GetGroupIdListForLdapUserRequest body, Context context) {
        return this.serviceManager.volumes().listGetGroupIdListForLdapUser(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void breakReplication() {
        this.serviceManager.volumes().breakReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void breakReplication(BreakReplicationRequest body, Context context) {
        this.serviceManager.volumes().breakReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void reestablishReplication(ReestablishReplicationRequest body) {
        this.serviceManager.volumes().reestablishReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public void reestablishReplication(ReestablishReplicationRequest body, Context context) {
        this.serviceManager.volumes().reestablishReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public PagedIterable<Replication> listReplications() {
        return this.serviceManager.volumes().listReplications(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public PagedIterable<Replication> listReplications(Context context) {
        return this.serviceManager.volumes().listReplications(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void resyncReplication() {
        this.serviceManager.volumes().resyncReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void resyncReplication(Context context) {
        this.serviceManager.volumes().resyncReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void deleteReplication() {
        this.serviceManager.volumes().deleteReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void deleteReplication(Context context) {
        this.serviceManager.volumes().deleteReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void authorizeReplication(AuthorizeRequest body) {
        this.serviceManager.volumes().authorizeReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public void authorizeReplication(AuthorizeRequest body, Context context) {
        this.serviceManager.volumes().authorizeReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void reInitializeReplication() {
        this.serviceManager.volumes().reInitializeReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void reInitializeReplication(Context context) {
        this.serviceManager.volumes().reInitializeReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public ClusterPeerCommandResponse peerExternalCluster(PeerClusterForVolumeMigrationRequest body) {
        return this.serviceManager.volumes().peerExternalCluster(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public ClusterPeerCommandResponse peerExternalCluster(PeerClusterForVolumeMigrationRequest body, Context context) {
        return this.serviceManager.volumes().peerExternalCluster(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public SvmPeerCommandResponse authorizeExternalReplication() {
        return this.serviceManager.volumes().authorizeExternalReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public SvmPeerCommandResponse authorizeExternalReplication(Context context) {
        return this.serviceManager.volumes().authorizeExternalReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void finalizeExternalReplication() {
        this.serviceManager.volumes().finalizeExternalReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void finalizeExternalReplication(Context context) {
        this.serviceManager.volumes().finalizeExternalReplication(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void performReplicationTransfer() {
        this.serviceManager.volumes().performReplicationTransfer(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void performReplicationTransfer(Context context) {
        this.serviceManager.volumes().performReplicationTransfer(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void poolChange(PoolChangeRequest body) {
        this.serviceManager.volumes().poolChange(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public void poolChange(PoolChangeRequest body, Context context) {
        this.serviceManager.volumes().poolChange(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void relocate() {
        this.serviceManager.volumes().relocate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void relocate(RelocateVolumeRequest body, Context context) {
        this.serviceManager.volumes().relocate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public void finalizeRelocation() {
        this.serviceManager.volumes().finalizeRelocation(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void finalizeRelocation(Context context) {
        this.serviceManager.volumes().finalizeRelocation(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public void revertRelocation() {
        this.serviceManager.volumes().revertRelocation(this.resourceGroupName, this.accountName, this.poolName, this.volumeName);
    }

    @Override
    public void revertRelocation(Context context) {
        this.serviceManager.volumes().revertRelocation(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context);
    }

    @Override
    public VolumeImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VolumeImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VolumeImpl withCreationToken(String creationToken) {
        this.innerModel().withCreationToken(creationToken);
        return this;
    }

    @Override
    public VolumeImpl withUsageThreshold(long usageThreshold) {
        this.innerModel().withUsageThreshold(usageThreshold);
        return this;
    }

    @Override
    public VolumeImpl withSubnetId(String subnetId) {
        this.innerModel().withSubnetId(subnetId);
        return this;
    }

    @Override
    public VolumeImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags((Map)tags);
        return this;
    }

    @Override
    public VolumeImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public VolumeImpl withServiceLevel(ServiceLevel serviceLevel) {
        if (this.isInCreateMode()) {
            this.innerModel().withServiceLevel(serviceLevel);
            return this;
        }
        this.updateBody.withServiceLevel(serviceLevel);
        return this;
    }

    @Override
    public VolumeImpl withExportPolicy(VolumePropertiesExportPolicy exportPolicy) {
        this.innerModel().withExportPolicy(exportPolicy);
        return this;
    }

    @Override
    public VolumeImpl withProtocolTypes(List<String> protocolTypes) {
        if (this.isInCreateMode()) {
            this.innerModel().withProtocolTypes(protocolTypes);
            return this;
        }
        this.updateBody.withProtocolTypes(protocolTypes);
        return this;
    }

    @Override
    public VolumeImpl withSnapshotId(String snapshotId) {
        this.innerModel().withSnapshotId(snapshotId);
        return this;
    }

    @Override
    public VolumeImpl withDeleteBaseSnapshot(Boolean deleteBaseSnapshot) {
        this.innerModel().withDeleteBaseSnapshot(deleteBaseSnapshot);
        return this;
    }

    @Override
    public VolumeImpl withBackupId(String backupId) {
        this.innerModel().withBackupId(backupId);
        return this;
    }

    @Override
    public VolumeImpl withNetworkFeatures(NetworkFeatures networkFeatures) {
        this.innerModel().withNetworkFeatures(networkFeatures);
        return this;
    }

    @Override
    public VolumeImpl withVolumeType(String volumeType) {
        this.innerModel().withVolumeType(volumeType);
        return this;
    }

    @Override
    public VolumeImpl withDataProtection(VolumePropertiesDataProtection dataProtection) {
        this.innerModel().withDataProtection(dataProtection);
        return this;
    }

    @Override
    public VolumeImpl withSnapshotDirectoryVisible(Boolean snapshotDirectoryVisible) {
        if (this.isInCreateMode()) {
            this.innerModel().withSnapshotDirectoryVisible(snapshotDirectoryVisible);
            return this;
        }
        this.updateBody.withSnapshotDirectoryVisible(snapshotDirectoryVisible);
        return this;
    }

    @Override
    public VolumeImpl withKerberosEnabled(Boolean kerberosEnabled) {
        this.innerModel().withKerberosEnabled(kerberosEnabled);
        return this;
    }

    @Override
    public VolumeImpl withSecurityStyle(SecurityStyle securityStyle) {
        this.innerModel().withSecurityStyle(securityStyle);
        return this;
    }

    @Override
    public VolumeImpl withSmbEncryption(Boolean smbEncryption) {
        this.innerModel().withSmbEncryption(smbEncryption);
        return this;
    }

    @Override
    public VolumeImpl withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration smbAccessBasedEnumeration) {
        if (this.isInCreateMode()) {
            this.innerModel().withSmbAccessBasedEnumeration(smbAccessBasedEnumeration);
            return this;
        }
        this.updateBody.withSmbAccessBasedEnumeration(smbAccessBasedEnumeration);
        return this;
    }

    @Override
    public VolumeImpl withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        if (this.isInCreateMode()) {
            this.innerModel().withSmbNonBrowsable(smbNonBrowsable);
            return this;
        }
        this.updateBody.withSmbNonBrowsable(smbNonBrowsable);
        return this;
    }

    @Override
    public VolumeImpl withSmbContinuouslyAvailable(Boolean smbContinuouslyAvailable) {
        this.innerModel().withSmbContinuouslyAvailable(smbContinuouslyAvailable);
        return this;
    }

    @Override
    public VolumeImpl withThroughputMibps(Float throughputMibps) {
        if (this.isInCreateMode()) {
            this.innerModel().withThroughputMibps(throughputMibps);
            return this;
        }
        this.updateBody.withThroughputMibps(throughputMibps);
        return this;
    }

    @Override
    public VolumeImpl withEncryptionKeySource(EncryptionKeySource encryptionKeySource) {
        this.innerModel().withEncryptionKeySource(encryptionKeySource);
        return this;
    }

    @Override
    public VolumeImpl withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        this.innerModel().withKeyVaultPrivateEndpointResourceId(keyVaultPrivateEndpointResourceId);
        return this;
    }

    @Override
    public VolumeImpl withLdapEnabled(Boolean ldapEnabled) {
        this.innerModel().withLdapEnabled(ldapEnabled);
        return this;
    }

    @Override
    public VolumeImpl withCoolAccess(Boolean coolAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withCoolAccess(coolAccess);
            return this;
        }
        this.updateBody.withCoolAccess(coolAccess);
        return this;
    }

    @Override
    public VolumeImpl withCoolnessPeriod(Integer coolnessPeriod) {
        if (this.isInCreateMode()) {
            this.innerModel().withCoolnessPeriod(coolnessPeriod);
            return this;
        }
        this.updateBody.withCoolnessPeriod(coolnessPeriod);
        return this;
    }

    @Override
    public VolumeImpl withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy coolAccessRetrievalPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withCoolAccessRetrievalPolicy(coolAccessRetrievalPolicy);
            return this;
        }
        this.updateBody.withCoolAccessRetrievalPolicy(coolAccessRetrievalPolicy);
        return this;
    }

    @Override
    public VolumeImpl withCoolAccessTieringPolicy(CoolAccessTieringPolicy coolAccessTieringPolicy) {
        if (this.isInCreateMode()) {
            this.innerModel().withCoolAccessTieringPolicy(coolAccessTieringPolicy);
            return this;
        }
        this.updateBody.withCoolAccessTieringPolicy(coolAccessTieringPolicy);
        return this;
    }

    @Override
    public VolumeImpl withUnixPermissions(String unixPermissions) {
        if (this.isInCreateMode()) {
            this.innerModel().withUnixPermissions(unixPermissions);
            return this;
        }
        this.updateBody.withUnixPermissions(unixPermissions);
        return this;
    }

    @Override
    public VolumeImpl withAvsDataStore(AvsDataStore avsDataStore) {
        this.innerModel().withAvsDataStore(avsDataStore);
        return this;
    }

    @Override
    public VolumeImpl withIsDefaultQuotaEnabled(Boolean isDefaultQuotaEnabled) {
        if (this.isInCreateMode()) {
            this.innerModel().withIsDefaultQuotaEnabled(isDefaultQuotaEnabled);
            return this;
        }
        this.updateBody.withIsDefaultQuotaEnabled(isDefaultQuotaEnabled);
        return this;
    }

    @Override
    public VolumeImpl withDefaultUserQuotaInKiBs(Long defaultUserQuotaInKiBs) {
        if (this.isInCreateMode()) {
            this.innerModel().withDefaultUserQuotaInKiBs(defaultUserQuotaInKiBs);
            return this;
        }
        this.updateBody.withDefaultUserQuotaInKiBs(defaultUserQuotaInKiBs);
        return this;
    }

    @Override
    public VolumeImpl withDefaultGroupQuotaInKiBs(Long defaultGroupQuotaInKiBs) {
        if (this.isInCreateMode()) {
            this.innerModel().withDefaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs);
            return this;
        }
        this.updateBody.withDefaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs);
        return this;
    }

    @Override
    public VolumeImpl withCapacityPoolResourceId(String capacityPoolResourceId) {
        this.innerModel().withCapacityPoolResourceId(capacityPoolResourceId);
        return this;
    }

    @Override
    public VolumeImpl withProximityPlacementGroup(String proximityPlacementGroup) {
        this.innerModel().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    @Override
    public VolumeImpl withVolumeSpecName(String volumeSpecName) {
        this.innerModel().withVolumeSpecName(volumeSpecName);
        return this;
    }

    @Override
    public VolumeImpl withPlacementRules(List<PlacementKeyValuePairs> placementRules) {
        this.innerModel().withPlacementRules(placementRules);
        return this;
    }

    @Override
    public VolumeImpl withEnableSubvolumes(EnableSubvolumes enableSubvolumes) {
        this.innerModel().withEnableSubvolumes(enableSubvolumes);
        return this;
    }

    @Override
    public VolumeImpl withIsLargeVolume(Boolean isLargeVolume) {
        this.innerModel().withIsLargeVolume(isLargeVolume);
        return this;
    }

    @Override
    public VolumeImpl withUsageThreshold(Long usageThreshold) {
        this.updateBody.withUsageThreshold(usageThreshold);
        return this;
    }

    @Override
    public VolumeImpl withExportPolicy(VolumePatchPropertiesExportPolicy exportPolicy) {
        this.updateBody.withExportPolicy(exportPolicy);
        return this;
    }

    @Override
    public VolumeImpl withDataProtection(VolumePatchPropertiesDataProtection dataProtection) {
        this.updateBody.withDataProtection(dataProtection);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

