/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.SubvolumeInfoInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.SubvolumeInfo;
import com.azure.resourcemanager.netapp.models.SubvolumeModel;
import com.azure.resourcemanager.netapp.models.SubvolumePatchRequest;

public final class SubvolumeInfoImpl
implements SubvolumeInfo,
SubvolumeInfo.Definition,
SubvolumeInfo.Update {
    private SubvolumeInfoInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private String subvolumeName;
    private SubvolumePatchRequest updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String path() {
        return this.innerModel().path();
    }

    @Override
    public Long size() {
        return this.innerModel().size();
    }

    @Override
    public String parentPath() {
        return this.innerModel().parentPath();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SubvolumeInfoInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SubvolumeInfoImpl withExistingVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        this.volumeName = volumeName;
        return this;
    }

    @Override
    public SubvolumeInfo create() {
        this.innerObject = this.serviceManager.serviceClient().getSubvolumes().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SubvolumeInfo create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSubvolumes().create(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, this.innerModel(), context);
        return this;
    }

    SubvolumeInfoImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new SubvolumeInfoInner();
        this.serviceManager = serviceManager;
        this.subvolumeName = name;
    }

    @Override
    public SubvolumeInfoImpl update() {
        this.updateBody = new SubvolumePatchRequest();
        return this;
    }

    @Override
    public SubvolumeInfo apply() {
        this.innerObject = this.serviceManager.serviceClient().getSubvolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public SubvolumeInfo apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSubvolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, this.updateBody, context);
        return this;
    }

    SubvolumeInfoImpl(SubvolumeInfoInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "capacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "volumes");
        this.subvolumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "subvolumes");
    }

    @Override
    public SubvolumeInfo refresh() {
        this.innerObject = (SubvolumeInfoInner)((Object)this.serviceManager.serviceClient().getSubvolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SubvolumeInfo refresh(Context context) {
        this.innerObject = (SubvolumeInfoInner)((Object)this.serviceManager.serviceClient().getSubvolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, context).getValue());
        return this;
    }

    @Override
    public SubvolumeModel getMetadata() {
        return this.serviceManager.subvolumes().getMetadata(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName);
    }

    @Override
    public SubvolumeModel getMetadata(Context context) {
        return this.serviceManager.subvolumes().getMetadata(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.subvolumeName, context);
    }

    @Override
    public SubvolumeInfoImpl withPath(String path) {
        if (this.isInCreateMode()) {
            this.innerModel().withPath(path);
            return this;
        }
        this.updateBody.withPath(path);
        return this;
    }

    @Override
    public SubvolumeInfoImpl withSize(Long size) {
        if (this.isInCreateMode()) {
            this.innerModel().withSize(size);
            return this;
        }
        this.updateBody.withSize(size);
        return this;
    }

    @Override
    public SubvolumeInfoImpl withParentPath(String parentPath) {
        this.innerModel().withParentPath(parentPath);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

