/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceQuotaLimitsClient;
import com.azure.resourcemanager.netapp.fluent.models.SubscriptionQuotaItemInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.SubscriptionQuotaItemImpl;
import com.azure.resourcemanager.netapp.models.NetAppResourceQuotaLimits;
import com.azure.resourcemanager.netapp.models.SubscriptionQuotaItem;

public final class NetAppResourceQuotaLimitsImpl
implements NetAppResourceQuotaLimits {
    private static final ClientLogger LOGGER = new ClientLogger(NetAppResourceQuotaLimitsImpl.class);
    private final NetAppResourceQuotaLimitsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public NetAppResourceQuotaLimitsImpl(NetAppResourceQuotaLimitsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SubscriptionQuotaItem> list(String location) {
        PagedIterable<SubscriptionQuotaItemInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionQuotaItemImpl((SubscriptionQuotaItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubscriptionQuotaItem> list(String location, Context context) {
        PagedIterable<SubscriptionQuotaItemInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SubscriptionQuotaItemImpl((SubscriptionQuotaItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SubscriptionQuotaItem> getWithResponse(String location, String quotaLimitName, Context context) {
        Response<SubscriptionQuotaItemInner> inner = this.serviceClient().getWithResponse(location, quotaLimitName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SubscriptionQuotaItemImpl((SubscriptionQuotaItemInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SubscriptionQuotaItem get(String location, String quotaLimitName) {
        SubscriptionQuotaItemInner inner = this.serviceClient().get(location, quotaLimitName);
        if (inner != null) {
            return new SubscriptionQuotaItemImpl(inner, this.manager());
        }
        return null;
    }

    private NetAppResourceQuotaLimitsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }
}

