/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.netapp.fluent.AccountsClient;
import com.azure.resourcemanager.netapp.fluent.BackupPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.BackupVaultsClient;
import com.azure.resourcemanager.netapp.fluent.BackupsClient;
import com.azure.resourcemanager.netapp.fluent.BackupsUnderAccountsClient;
import com.azure.resourcemanager.netapp.fluent.BackupsUnderBackupVaultsClient;
import com.azure.resourcemanager.netapp.fluent.BackupsUnderVolumesClient;
import com.azure.resourcemanager.netapp.fluent.NetAppManagementClient;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceQuotaLimitsClient;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceRegionInfosClient;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceUsagesClient;
import com.azure.resourcemanager.netapp.fluent.NetAppResourcesClient;
import com.azure.resourcemanager.netapp.fluent.OperationsClient;
import com.azure.resourcemanager.netapp.fluent.PoolsClient;
import com.azure.resourcemanager.netapp.fluent.SnapshotPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.SnapshotsClient;
import com.azure.resourcemanager.netapp.fluent.SubvolumesClient;
import com.azure.resourcemanager.netapp.fluent.VolumeGroupsClient;
import com.azure.resourcemanager.netapp.fluent.VolumeQuotaRulesClient;
import com.azure.resourcemanager.netapp.fluent.VolumesClient;
import com.azure.resourcemanager.netapp.implementation.AccountsClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupPoliciesClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupVaultsClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderAccountsClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderBackupVaultsClientImpl;
import com.azure.resourcemanager.netapp.implementation.BackupsUnderVolumesClientImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientBuilder;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceQuotaLimitsClientImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceRegionInfosClientImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourceUsagesClientImpl;
import com.azure.resourcemanager.netapp.implementation.NetAppResourcesClientImpl;
import com.azure.resourcemanager.netapp.implementation.OperationsClientImpl;
import com.azure.resourcemanager.netapp.implementation.PoolsClientImpl;
import com.azure.resourcemanager.netapp.implementation.SnapshotPoliciesClientImpl;
import com.azure.resourcemanager.netapp.implementation.SnapshotsClientImpl;
import com.azure.resourcemanager.netapp.implementation.SubvolumesClientImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeGroupsClientImpl;
import com.azure.resourcemanager.netapp.implementation.VolumeQuotaRulesClientImpl;
import com.azure.resourcemanager.netapp.implementation.VolumesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=NetAppManagementClientBuilder.class)
public final class NetAppManagementClientImpl
implements NetAppManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final NetAppResourcesClient netAppResources;
    private final NetAppResourceUsagesClient netAppResourceUsages;
    private final NetAppResourceQuotaLimitsClient netAppResourceQuotaLimits;
    private final NetAppResourceRegionInfosClient netAppResourceRegionInfos;
    private final AccountsClient accounts;
    private final PoolsClient pools;
    private final VolumesClient volumes;
    private final SnapshotsClient snapshots;
    private final SnapshotPoliciesClient snapshotPolicies;
    private final BackupPoliciesClient backupPolicies;
    private final VolumeQuotaRulesClient volumeQuotaRules;
    private final VolumeGroupsClient volumeGroups;
    private final SubvolumesClient subvolumes;
    private final BackupsClient backups;
    private final BackupVaultsClient backupVaults;
    private final BackupsUnderBackupVaultsClient backupsUnderBackupVaults;
    private final BackupsUnderVolumesClient backupsUnderVolumes;
    private final BackupsUnderAccountsClient backupsUnderAccounts;
    private static final ClientLogger LOGGER = new ClientLogger(NetAppManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public NetAppResourcesClient getNetAppResources() {
        return this.netAppResources;
    }

    @Override
    public NetAppResourceUsagesClient getNetAppResourceUsages() {
        return this.netAppResourceUsages;
    }

    @Override
    public NetAppResourceQuotaLimitsClient getNetAppResourceQuotaLimits() {
        return this.netAppResourceQuotaLimits;
    }

    @Override
    public NetAppResourceRegionInfosClient getNetAppResourceRegionInfos() {
        return this.netAppResourceRegionInfos;
    }

    @Override
    public AccountsClient getAccounts() {
        return this.accounts;
    }

    @Override
    public PoolsClient getPools() {
        return this.pools;
    }

    @Override
    public VolumesClient getVolumes() {
        return this.volumes;
    }

    @Override
    public SnapshotsClient getSnapshots() {
        return this.snapshots;
    }

    @Override
    public SnapshotPoliciesClient getSnapshotPolicies() {
        return this.snapshotPolicies;
    }

    @Override
    public BackupPoliciesClient getBackupPolicies() {
        return this.backupPolicies;
    }

    @Override
    public VolumeQuotaRulesClient getVolumeQuotaRules() {
        return this.volumeQuotaRules;
    }

    @Override
    public VolumeGroupsClient getVolumeGroups() {
        return this.volumeGroups;
    }

    @Override
    public SubvolumesClient getSubvolumes() {
        return this.subvolumes;
    }

    @Override
    public BackupsClient getBackups() {
        return this.backups;
    }

    @Override
    public BackupVaultsClient getBackupVaults() {
        return this.backupVaults;
    }

    @Override
    public BackupsUnderBackupVaultsClient getBackupsUnderBackupVaults() {
        return this.backupsUnderBackupVaults;
    }

    @Override
    public BackupsUnderVolumesClient getBackupsUnderVolumes() {
        return this.backupsUnderVolumes;
    }

    @Override
    public BackupsUnderAccountsClient getBackupsUnderAccounts() {
        return this.backupsUnderAccounts;
    }

    NetAppManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-01-01";
        this.operations = new OperationsClientImpl(this);
        this.netAppResources = new NetAppResourcesClientImpl(this);
        this.netAppResourceUsages = new NetAppResourceUsagesClientImpl(this);
        this.netAppResourceQuotaLimits = new NetAppResourceQuotaLimitsClientImpl(this);
        this.netAppResourceRegionInfos = new NetAppResourceRegionInfosClientImpl(this);
        this.accounts = new AccountsClientImpl(this);
        this.pools = new PoolsClientImpl(this);
        this.volumes = new VolumesClientImpl(this);
        this.snapshots = new SnapshotsClientImpl(this);
        this.snapshotPolicies = new SnapshotPoliciesClientImpl(this);
        this.backupPolicies = new BackupPoliciesClientImpl(this);
        this.volumeQuotaRules = new VolumeQuotaRulesClientImpl(this);
        this.volumeGroups = new VolumeGroupsClientImpl(this);
        this.subvolumes = new SubvolumesClientImpl(this);
        this.backups = new BackupsClientImpl(this);
        this.backupVaults = new BackupVaultsClientImpl(this);
        this.backupsUnderBackupVaults = new BackupsUnderBackupVaultsClientImpl(this);
        this.backupsUnderVolumes = new BackupsUnderVolumesClientImpl(this);
        this.backupsUnderAccounts = new BackupsUnderAccountsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

