/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.NetAppAccountInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.AccountEncryption;
import com.azure.resourcemanager.netapp.models.ActiveDirectory;
import com.azure.resourcemanager.netapp.models.ChangeKeyVault;
import com.azure.resourcemanager.netapp.models.EncryptionTransitionRequest;
import com.azure.resourcemanager.netapp.models.GetKeyVaultStatusResponse;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import com.azure.resourcemanager.netapp.models.MultiAdStatus;
import com.azure.resourcemanager.netapp.models.NetAppAccount;
import com.azure.resourcemanager.netapp.models.NetAppAccountPatch;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NetAppAccountImpl
implements NetAppAccount,
NetAppAccount.Definition,
NetAppAccount.Update {
    private NetAppAccountInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private NetAppAccountPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<ActiveDirectory> activeDirectories() {
        List<ActiveDirectory> inner = this.innerModel().activeDirectories();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public AccountEncryption encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public Boolean disableShowmount() {
        return this.innerModel().disableShowmount();
    }

    @Override
    public String nfsV4IdDomain() {
        return this.innerModel().nfsV4IdDomain();
    }

    @Override
    public MultiAdStatus multiAdStatus() {
        return this.innerModel().multiAdStatus();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NetAppAccountInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public NetAppAccountImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public NetAppAccount create() {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NetAppAccount create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), context);
        return this;
    }

    NetAppAccountImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new NetAppAccountInner();
        this.serviceManager = serviceManager;
        this.accountName = name;
    }

    @Override
    public NetAppAccountImpl update() {
        this.updateBody = new NetAppAccountPatch();
        return this;
    }

    @Override
    public NetAppAccount apply() {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().update(this.resourceGroupName, this.accountName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public NetAppAccount apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().update(this.resourceGroupName, this.accountName, this.updateBody, context);
        return this;
    }

    NetAppAccountImpl(NetAppAccountInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
    }

    @Override
    public NetAppAccount refresh() {
        this.innerObject = (NetAppAccountInner)((Object)this.serviceManager.serviceClient().getAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NetAppAccount refresh(Context context) {
        this.innerObject = (NetAppAccountInner)((Object)this.serviceManager.serviceClient().getAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, context).getValue());
        return this;
    }

    @Override
    public void renewCredentials() {
        this.serviceManager.accounts().renewCredentials(this.resourceGroupName, this.accountName);
    }

    @Override
    public void renewCredentials(Context context) {
        this.serviceManager.accounts().renewCredentials(this.resourceGroupName, this.accountName, context);
    }

    @Override
    public void transitionToCmk() {
        this.serviceManager.accounts().transitionToCmk(this.resourceGroupName, this.accountName);
    }

    @Override
    public void transitionToCmk(EncryptionTransitionRequest body, Context context) {
        this.serviceManager.accounts().transitionToCmk(this.resourceGroupName, this.accountName, body, context);
    }

    @Override
    public GetKeyVaultStatusResponse getChangeKeyVaultInformation() {
        return this.serviceManager.accounts().getChangeKeyVaultInformation(this.resourceGroupName, this.accountName);
    }

    @Override
    public GetKeyVaultStatusResponse getChangeKeyVaultInformation(Context context) {
        return this.serviceManager.accounts().getChangeKeyVaultInformation(this.resourceGroupName, this.accountName, context);
    }

    @Override
    public void changeKeyVault() {
        this.serviceManager.accounts().changeKeyVault(this.resourceGroupName, this.accountName);
    }

    @Override
    public void changeKeyVault(ChangeKeyVault body, Context context) {
        this.serviceManager.accounts().changeKeyVault(this.resourceGroupName, this.accountName, body, context);
    }

    @Override
    public NetAppAccountImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public NetAppAccountImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public NetAppAccountImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags((Map)tags);
        return this;
    }

    @Override
    public NetAppAccountImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateBody.withIdentity(identity);
        return this;
    }

    @Override
    public NetAppAccountImpl withActiveDirectories(List<ActiveDirectory> activeDirectories) {
        if (this.isInCreateMode()) {
            this.innerModel().withActiveDirectories(activeDirectories);
            return this;
        }
        this.updateBody.withActiveDirectories(activeDirectories);
        return this;
    }

    @Override
    public NetAppAccountImpl withEncryption(AccountEncryption encryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withEncryption(encryption);
            return this;
        }
        this.updateBody.withEncryption(encryption);
        return this;
    }

    @Override
    public NetAppAccountImpl withNfsV4IdDomain(String nfsV4IdDomain) {
        if (this.isInCreateMode()) {
            this.innerModel().withNfsV4IdDomain(nfsV4IdDomain);
            return this;
        }
        this.updateBody.withNfsV4IdDomain(nfsV4IdDomain);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

