/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.BackupVaultInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.BackupVault;
import com.azure.resourcemanager.netapp.models.BackupVaultPatch;
import java.util.Collections;
import java.util.Map;

public final class BackupVaultImpl
implements BackupVault,
BackupVault.Definition,
BackupVault.Update {
    private BackupVaultInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupVaultName;
    private BackupVaultPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackupVaultInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupVaultImpl withExistingNetAppAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BackupVault create() {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BackupVault create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.innerModel(), context);
        return this;
    }

    BackupVaultImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new BackupVaultInner();
        this.serviceManager = serviceManager;
        this.backupVaultName = name;
    }

    @Override
    public BackupVaultImpl update() {
        this.updateBody = new BackupVaultPatch();
        return this;
    }

    @Override
    public BackupVault apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public BackupVault apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupVaults().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.updateBody, context);
        return this;
    }

    BackupVaultImpl(BackupVaultInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.backupVaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
    }

    @Override
    public BackupVault refresh() {
        this.innerObject = (BackupVaultInner)((Object)this.serviceManager.serviceClient().getBackupVaults().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BackupVault refresh(Context context) {
        this.innerObject = (BackupVaultInner)((Object)this.serviceManager.serviceClient().getBackupVaults().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, context).getValue());
        return this;
    }

    @Override
    public BackupVaultImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BackupVaultImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BackupVaultImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

