/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.BackupPolicyInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.BackupPolicy;
import com.azure.resourcemanager.netapp.models.BackupPolicyPatch;
import com.azure.resourcemanager.netapp.models.VolumeBackups;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BackupPolicyImpl
implements BackupPolicy,
BackupPolicy.Definition,
BackupPolicy.Update {
    private BackupPolicyInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupPolicyName;
    private BackupPolicyPatch updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String backupPolicyId() {
        return this.innerModel().backupPolicyId();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Integer dailyBackupsToKeep() {
        return this.innerModel().dailyBackupsToKeep();
    }

    @Override
    public Integer weeklyBackupsToKeep() {
        return this.innerModel().weeklyBackupsToKeep();
    }

    @Override
    public Integer monthlyBackupsToKeep() {
        return this.innerModel().monthlyBackupsToKeep();
    }

    @Override
    public Integer volumesAssigned() {
        return this.innerModel().volumesAssigned();
    }

    @Override
    public Boolean enabled() {
        return this.innerModel().enabled();
    }

    @Override
    public List<VolumeBackups> volumeBackups() {
        List<VolumeBackups> inner = this.innerModel().volumeBackups();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackupPolicyInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupPolicyImpl withExistingNetAppAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BackupPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getBackupPolicies().create(this.resourceGroupName, this.accountName, this.backupPolicyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BackupPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupPolicies().create(this.resourceGroupName, this.accountName, this.backupPolicyName, this.innerModel(), context);
        return this;
    }

    BackupPolicyImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new BackupPolicyInner();
        this.serviceManager = serviceManager;
        this.backupPolicyName = name;
    }

    @Override
    public BackupPolicyImpl update() {
        this.updateBody = new BackupPolicyPatch();
        return this;
    }

    @Override
    public BackupPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackupPolicies().update(this.resourceGroupName, this.accountName, this.backupPolicyName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public BackupPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupPolicies().update(this.resourceGroupName, this.accountName, this.backupPolicyName, this.updateBody, context);
        return this;
    }

    BackupPolicyImpl(BackupPolicyInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "netAppAccounts");
        this.backupPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupPolicies");
    }

    @Override
    public BackupPolicy refresh() {
        this.innerObject = (BackupPolicyInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.backupPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BackupPolicy refresh(Context context) {
        this.innerObject = (BackupPolicyInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.backupPolicyName, context).getValue());
        return this;
    }

    @Override
    public BackupPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BackupPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BackupPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags((Map)tags);
        return this;
    }

    @Override
    public BackupPolicyImpl withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        if (this.isInCreateMode()) {
            this.innerModel().withDailyBackupsToKeep(dailyBackupsToKeep);
            return this;
        }
        this.updateBody.withDailyBackupsToKeep(dailyBackupsToKeep);
        return this;
    }

    @Override
    public BackupPolicyImpl withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        if (this.isInCreateMode()) {
            this.innerModel().withWeeklyBackupsToKeep(weeklyBackupsToKeep);
            return this;
        }
        this.updateBody.withWeeklyBackupsToKeep(weeklyBackupsToKeep);
        return this;
    }

    @Override
    public BackupPolicyImpl withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        if (this.isInCreateMode()) {
            this.innerModel().withMonthlyBackupsToKeep(monthlyBackupsToKeep);
            return this;
        }
        this.updateBody.withMonthlyBackupsToKeep(monthlyBackupsToKeep);
        return this;
    }

    @Override
    public BackupPolicyImpl withEnabled(Boolean enabled) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabled(enabled);
            return this;
        }
        this.updateBody.withEnabled(enabled);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

