/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.VolumeGroupMetadata;
import com.azure.resourcemanager.netapp.models.VolumeGroupVolumeProperties;
import java.io.IOException;
import java.util.List;

public final class VolumeGroupProperties
implements JsonSerializable<VolumeGroupProperties> {
    private String provisioningState;
    private VolumeGroupMetadata groupMetadata;
    private List<VolumeGroupVolumeProperties> volumes;

    public String provisioningState() {
        return this.provisioningState;
    }

    public VolumeGroupMetadata groupMetadata() {
        return this.groupMetadata;
    }

    public VolumeGroupProperties withGroupMetadata(VolumeGroupMetadata groupMetadata) {
        this.groupMetadata = groupMetadata;
        return this;
    }

    public List<VolumeGroupVolumeProperties> volumes() {
        return this.volumes;
    }

    public VolumeGroupProperties withVolumes(List<VolumeGroupVolumeProperties> volumes) {
        this.volumes = volumes;
        return this;
    }

    public void validate() {
        if (this.groupMetadata() != null) {
            this.groupMetadata().validate();
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("groupMetaData", (JsonSerializable)this.groupMetadata);
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupProperties)jsonReader.readObject(reader -> {
            VolumeGroupProperties deserializedVolumeGroupProperties = new VolumeGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeGroupProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("groupMetaData".equals(fieldName)) {
                    deserializedVolumeGroupProperties.groupMetadata = VolumeGroupMetadata.fromJson(reader);
                    continue;
                }
                if ("volumes".equals(fieldName)) {
                    List volumes;
                    deserializedVolumeGroupProperties.volumes = volumes = reader.readArray(reader1 -> VolumeGroupVolumeProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupProperties;
        });
    }
}

