/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MountTargetProperties
implements JsonSerializable<MountTargetProperties> {
    private String mountTargetId;
    private String fileSystemId;
    private String ipAddress;
    private String smbServerFqdn;
    private static final ClientLogger LOGGER = new ClientLogger(MountTargetProperties.class);

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public MountTargetProperties withFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String smbServerFqdn() {
        return this.smbServerFqdn;
    }

    public MountTargetProperties withSmbServerFqdn(String smbServerFqdn) {
        this.smbServerFqdn = smbServerFqdn;
        return this;
    }

    public void validate() {
        if (this.fileSystemId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fileSystemId in model MountTargetProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileSystemId", this.fileSystemId);
        jsonWriter.writeStringField("smbServerFqdn", this.smbServerFqdn);
        return jsonWriter.writeEndObject();
    }

    public static MountTargetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MountTargetProperties)jsonReader.readObject(reader -> {
            MountTargetProperties deserializedMountTargetProperties = new MountTargetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileSystemId".equals(fieldName)) {
                    deserializedMountTargetProperties.fileSystemId = reader.getString();
                    continue;
                }
                if ("mountTargetId".equals(fieldName)) {
                    deserializedMountTargetProperties.mountTargetId = reader.getString();
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedMountTargetProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("smbServerFqdn".equals(fieldName)) {
                    deserializedMountTargetProperties.smbServerFqdn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMountTargetProperties;
        });
    }
}

