/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.KeyVaultPrivateEndpoint;
import java.io.IOException;
import java.util.List;

public final class GetKeyVaultStatusResponseProperties
implements JsonSerializable<GetKeyVaultStatusResponseProperties> {
    private String keyVaultUri;
    private String keyName;
    private String keyVaultResourceId;
    private List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints;

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public GetKeyVaultStatusResponseProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String keyName() {
        return this.keyName;
    }

    public GetKeyVaultStatusResponseProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    public GetKeyVaultStatusResponseProperties withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    public List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints() {
        return this.keyVaultPrivateEndpoints;
    }

    public GetKeyVaultStatusResponseProperties withKeyVaultPrivateEndpoints(List<KeyVaultPrivateEndpoint> keyVaultPrivateEndpoints) {
        this.keyVaultPrivateEndpoints = keyVaultPrivateEndpoints;
        return this;
    }

    public void validate() {
        if (this.keyVaultPrivateEndpoints() != null) {
            this.keyVaultPrivateEndpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("keyVaultResourceId", this.keyVaultResourceId);
        jsonWriter.writeArrayField("keyVaultPrivateEndpoints", this.keyVaultPrivateEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GetKeyVaultStatusResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GetKeyVaultStatusResponseProperties)jsonReader.readObject(reader -> {
            GetKeyVaultStatusResponseProperties deserializedGetKeyVaultStatusResponseProperties = new GetKeyVaultStatusResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedGetKeyVaultStatusResponseProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("keyName".equals(fieldName)) {
                    deserializedGetKeyVaultStatusResponseProperties.keyName = reader.getString();
                    continue;
                }
                if ("keyVaultResourceId".equals(fieldName)) {
                    deserializedGetKeyVaultStatusResponseProperties.keyVaultResourceId = reader.getString();
                    continue;
                }
                if ("keyVaultPrivateEndpoints".equals(fieldName)) {
                    List keyVaultPrivateEndpoints;
                    deserializedGetKeyVaultStatusResponseProperties.keyVaultPrivateEndpoints = keyVaultPrivateEndpoints = reader.readArray(reader1 -> KeyVaultPrivateEndpoint.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetKeyVaultStatusResponseProperties;
        });
    }
}

