/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.BackupProperties;
import com.azure.resourcemanager.netapp.models.BackupType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BackupInner
extends ProxyResource {
    private BackupProperties innerProperties = new BackupProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(BackupInner.class);

    private BackupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String backupId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupId();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public OffsetDateTime snapshotCreationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotCreationDate();
    }

    public OffsetDateTime completionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().completionDate();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Long size() {
        return this.innerProperties() == null ? null : this.innerProperties().size();
    }

    public String label() {
        return this.innerProperties() == null ? null : this.innerProperties().label();
    }

    public BackupInner withLabel(String label) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupProperties();
        }
        this.innerProperties().withLabel(label);
        return this;
    }

    public BackupType backupType() {
        return this.innerProperties() == null ? null : this.innerProperties().backupType();
    }

    public String failureReason() {
        return this.innerProperties() == null ? null : this.innerProperties().failureReason();
    }

    public String volumeResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeResourceId();
    }

    public BackupInner withVolumeResourceId(String volumeResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupProperties();
        }
        this.innerProperties().withVolumeResourceId(volumeResourceId);
        return this;
    }

    public Boolean useExistingSnapshot() {
        return this.innerProperties() == null ? null : this.innerProperties().useExistingSnapshot();
    }

    public BackupInner withUseExistingSnapshot(Boolean useExistingSnapshot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupProperties();
        }
        this.innerProperties().withUseExistingSnapshot(useExistingSnapshot);
        return this;
    }

    public String snapshotName() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotName();
    }

    public BackupInner withSnapshotName(String snapshotName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupProperties();
        }
        this.innerProperties().withSnapshotName(snapshotName);
        return this;
    }

    public String backupPolicyResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicyResourceId();
    }

    public Boolean isLargeVolume() {
        return this.innerProperties() == null ? null : this.innerProperties().isLargeVolume();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model BackupInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BackupInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupInner)((Object)jsonReader.readObject(reader -> {
            BackupInner deserializedBackupInner = new BackupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupInner.innerProperties = BackupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBackupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupInner;
        }));
    }
}

