/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.BranchProperties;
import com.azure.resourcemanager.neonpostgres.models.DefaultEndpointSettings;
import com.azure.resourcemanager.neonpostgres.models.EndpointProperties;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabaseProperties;
import com.azure.resourcemanager.neonpostgres.models.NeonRoleProperties;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ProjectProperties
implements JsonSerializable<ProjectProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String regionId;
    private Long storage;
    private Integer pgVersion;
    private Integer historyRetention;
    private DefaultEndpointSettings defaultEndpointSettings;
    private BranchProperties branch;
    private List<NeonRoleProperties> roles;
    private List<NeonDatabaseProperties> databases;
    private List<EndpointProperties> endpoints;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public ProjectProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public ProjectProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String regionId() {
        return this.regionId;
    }

    public ProjectProperties withRegionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public Long storage() {
        return this.storage;
    }

    public ProjectProperties withStorage(Long storage) {
        this.storage = storage;
        return this;
    }

    public Integer pgVersion() {
        return this.pgVersion;
    }

    public ProjectProperties withPgVersion(Integer pgVersion) {
        this.pgVersion = pgVersion;
        return this;
    }

    public Integer historyRetention() {
        return this.historyRetention;
    }

    public ProjectProperties withHistoryRetention(Integer historyRetention) {
        this.historyRetention = historyRetention;
        return this;
    }

    public DefaultEndpointSettings defaultEndpointSettings() {
        return this.defaultEndpointSettings;
    }

    public ProjectProperties withDefaultEndpointSettings(DefaultEndpointSettings defaultEndpointSettings) {
        this.defaultEndpointSettings = defaultEndpointSettings;
        return this;
    }

    public BranchProperties branch() {
        return this.branch;
    }

    public ProjectProperties withBranch(BranchProperties branch) {
        this.branch = branch;
        return this;
    }

    public List<NeonRoleProperties> roles() {
        return this.roles;
    }

    public ProjectProperties withRoles(List<NeonRoleProperties> roles) {
        this.roles = roles;
        return this;
    }

    public List<NeonDatabaseProperties> databases() {
        return this.databases;
    }

    public ProjectProperties withDatabases(List<NeonDatabaseProperties> databases) {
        this.databases = databases;
        return this;
    }

    public List<EndpointProperties> endpoints() {
        return this.endpoints;
    }

    public ProjectProperties withEndpoints(List<EndpointProperties> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
        if (this.defaultEndpointSettings() != null) {
            this.defaultEndpointSettings().validate();
        }
        if (this.branch() != null) {
            this.branch().validate();
        }
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("regionId", this.regionId);
        jsonWriter.writeNumberField("storage", (Number)this.storage);
        jsonWriter.writeNumberField("pgVersion", (Number)this.pgVersion);
        jsonWriter.writeNumberField("historyRetention", (Number)this.historyRetention);
        jsonWriter.writeJsonField("defaultEndpointSettings", (JsonSerializable)this.defaultEndpointSettings);
        jsonWriter.writeJsonField("branch", (JsonSerializable)this.branch);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ProjectProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectProperties)jsonReader.readObject(reader -> {
            ProjectProperties deserializedProjectProperties = new ProjectProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedProjectProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedProjectProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedProjectProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedProjectProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedProjectProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("regionId".equals(fieldName)) {
                    deserializedProjectProperties.regionId = reader.getString();
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedProjectProperties.storage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("pgVersion".equals(fieldName)) {
                    deserializedProjectProperties.pgVersion = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("historyRetention".equals(fieldName)) {
                    deserializedProjectProperties.historyRetention = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultEndpointSettings".equals(fieldName)) {
                    deserializedProjectProperties.defaultEndpointSettings = DefaultEndpointSettings.fromJson(reader);
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedProjectProperties.branch = BranchProperties.fromJson(reader);
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedProjectProperties.roles = roles = reader.readArray(reader1 -> NeonRoleProperties.fromJson(reader1));
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedProjectProperties.databases = databases = reader.readArray(reader1 -> NeonDatabaseProperties.fromJson(reader1));
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedProjectProperties.endpoints = endpoints = reader.readArray(reader1 -> EndpointProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectProperties;
        });
    }
}

