/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.SingleSignOnProperties;
import java.io.IOException;

public final class PartnerOrganizationProperties
implements JsonSerializable<PartnerOrganizationProperties> {
    private String organizationId;
    private String organizationName;
    private SingleSignOnProperties singleSignOnProperties;
    private static final ClientLogger LOGGER = new ClientLogger(PartnerOrganizationProperties.class);

    public String organizationId() {
        return this.organizationId;
    }

    public PartnerOrganizationProperties withOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public PartnerOrganizationProperties withOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public SingleSignOnProperties singleSignOnProperties() {
        return this.singleSignOnProperties;
    }

    public PartnerOrganizationProperties withSingleSignOnProperties(SingleSignOnProperties singleSignOnProperties) {
        this.singleSignOnProperties = singleSignOnProperties;
        return this;
    }

    public void validate() {
        if (this.organizationName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property organizationName in model PartnerOrganizationProperties"));
        }
        if (this.singleSignOnProperties() != null) {
            this.singleSignOnProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("organizationName", this.organizationName);
        jsonWriter.writeStringField("organizationId", this.organizationId);
        jsonWriter.writeJsonField("singleSignOnProperties", (JsonSerializable)this.singleSignOnProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerOrganizationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerOrganizationProperties)jsonReader.readObject(reader -> {
            PartnerOrganizationProperties deserializedPartnerOrganizationProperties = new PartnerOrganizationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("organizationName".equals(fieldName)) {
                    deserializedPartnerOrganizationProperties.organizationName = reader.getString();
                    continue;
                }
                if ("organizationId".equals(fieldName)) {
                    deserializedPartnerOrganizationProperties.organizationId = reader.getString();
                    continue;
                }
                if ("singleSignOnProperties".equals(fieldName)) {
                    deserializedPartnerOrganizationProperties.singleSignOnProperties = SingleSignOnProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerOrganizationProperties;
        });
    }
}

