/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.CompanyDetails;
import com.azure.resourcemanager.neonpostgres.models.MarketplaceDetails;
import com.azure.resourcemanager.neonpostgres.models.PartnerOrganizationProperties;
import com.azure.resourcemanager.neonpostgres.models.ProjectProperties;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import com.azure.resourcemanager.neonpostgres.models.UserDetails;
import java.io.IOException;

public final class OrganizationProperties
implements JsonSerializable<OrganizationProperties> {
    private MarketplaceDetails marketplaceDetails;
    private UserDetails userDetails;
    private CompanyDetails companyDetails;
    private ResourceProvisioningState provisioningState;
    private PartnerOrganizationProperties partnerOrganizationProperties;
    private ProjectProperties projectProperties;
    private static final ClientLogger LOGGER = new ClientLogger(OrganizationProperties.class);

    public MarketplaceDetails marketplaceDetails() {
        return this.marketplaceDetails;
    }

    public OrganizationProperties withMarketplaceDetails(MarketplaceDetails marketplaceDetails) {
        this.marketplaceDetails = marketplaceDetails;
        return this;
    }

    public UserDetails userDetails() {
        return this.userDetails;
    }

    public OrganizationProperties withUserDetails(UserDetails userDetails) {
        this.userDetails = userDetails;
        return this;
    }

    public CompanyDetails companyDetails() {
        return this.companyDetails;
    }

    public OrganizationProperties withCompanyDetails(CompanyDetails companyDetails) {
        this.companyDetails = companyDetails;
        return this;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PartnerOrganizationProperties partnerOrganizationProperties() {
        return this.partnerOrganizationProperties;
    }

    public OrganizationProperties withPartnerOrganizationProperties(PartnerOrganizationProperties partnerOrganizationProperties) {
        this.partnerOrganizationProperties = partnerOrganizationProperties;
        return this;
    }

    public ProjectProperties projectProperties() {
        return this.projectProperties;
    }

    public OrganizationProperties withProjectProperties(ProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
        return this;
    }

    public void validate() {
        if (this.marketplaceDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property marketplaceDetails in model OrganizationProperties"));
        }
        this.marketplaceDetails().validate();
        if (this.userDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userDetails in model OrganizationProperties"));
        }
        this.userDetails().validate();
        if (this.companyDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property companyDetails in model OrganizationProperties"));
        }
        this.companyDetails().validate();
        if (this.partnerOrganizationProperties() != null) {
            this.partnerOrganizationProperties().validate();
        }
        if (this.projectProperties() != null) {
            this.projectProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("marketplaceDetails", (JsonSerializable)this.marketplaceDetails);
        jsonWriter.writeJsonField("userDetails", (JsonSerializable)this.userDetails);
        jsonWriter.writeJsonField("companyDetails", (JsonSerializable)this.companyDetails);
        jsonWriter.writeJsonField("partnerOrganizationProperties", (JsonSerializable)this.partnerOrganizationProperties);
        jsonWriter.writeJsonField("projectProperties", (JsonSerializable)this.projectProperties);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationProperties)jsonReader.readObject(reader -> {
            OrganizationProperties deserializedOrganizationProperties = new OrganizationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("marketplaceDetails".equals(fieldName)) {
                    deserializedOrganizationProperties.marketplaceDetails = MarketplaceDetails.fromJson(reader);
                    continue;
                }
                if ("userDetails".equals(fieldName)) {
                    deserializedOrganizationProperties.userDetails = UserDetails.fromJson(reader);
                    continue;
                }
                if ("companyDetails".equals(fieldName)) {
                    deserializedOrganizationProperties.companyDetails = CompanyDetails.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOrganizationProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("partnerOrganizationProperties".equals(fieldName)) {
                    deserializedOrganizationProperties.partnerOrganizationProperties = PartnerOrganizationProperties.fromJson(reader);
                    continue;
                }
                if ("projectProperties".equals(fieldName)) {
                    deserializedOrganizationProperties.projectProperties = ProjectProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationProperties;
        });
    }
}

