/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NeonDatabaseProperties
implements JsonSerializable<NeonDatabaseProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String branchId;
    private String ownerName;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public NeonDatabaseProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public NeonDatabaseProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String branchId() {
        return this.branchId;
    }

    public NeonDatabaseProperties withBranchId(String branchId) {
        this.branchId = branchId;
        return this;
    }

    public String ownerName() {
        return this.ownerName;
    }

    public NeonDatabaseProperties withOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("branchId", this.branchId);
        jsonWriter.writeStringField("ownerName", this.ownerName);
        return jsonWriter.writeEndObject();
    }

    public static NeonDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NeonDatabaseProperties)jsonReader.readObject(reader -> {
            NeonDatabaseProperties deserializedNeonDatabaseProperties = new NeonDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedNeonDatabaseProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("branchId".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.branchId = reader.getString();
                    continue;
                }
                if ("ownerName".equals(fieldName)) {
                    deserializedNeonDatabaseProperties.ownerName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNeonDatabaseProperties;
        });
    }
}

