/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.Attributes;
import com.azure.resourcemanager.neonpostgres.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ComputeProperties
implements JsonSerializable<ComputeProperties> {
    private String entityId;
    private String entityName;
    private String createdAt;
    private ResourceProvisioningState provisioningState;
    private List<Attributes> attributes;
    private String region;
    private Integer cpuCores;
    private Integer memory;
    private String status;

    public String entityId() {
        return this.entityId;
    }

    public String entityName() {
        return this.entityName;
    }

    public ComputeProperties withEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<Attributes> attributes() {
        return this.attributes;
    }

    public ComputeProperties withAttributes(List<Attributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String region() {
        return this.region;
    }

    public ComputeProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    public Integer cpuCores() {
        return this.cpuCores;
    }

    public ComputeProperties withCpuCores(Integer cpuCores) {
        this.cpuCores = cpuCores;
        return this;
    }

    public Integer memory() {
        return this.memory;
    }

    public ComputeProperties withMemory(Integer memory) {
        this.memory = memory;
        return this;
    }

    public String status() {
        return this.status;
    }

    public ComputeProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("entityName", this.entityName);
        jsonWriter.writeArrayField("attributes", this.attributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeNumberField("cpuCores", (Number)this.cpuCores);
        jsonWriter.writeNumberField("memory", (Number)this.memory);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    public static ComputeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ComputeProperties)jsonReader.readObject(reader -> {
            ComputeProperties deserializedComputeProperties = new ComputeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("entityId".equals(fieldName)) {
                    deserializedComputeProperties.entityId = reader.getString();
                    continue;
                }
                if ("entityName".equals(fieldName)) {
                    deserializedComputeProperties.entityName = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedComputeProperties.createdAt = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedComputeProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    List attributes;
                    deserializedComputeProperties.attributes = attributes = reader.readArray(reader1 -> Attributes.fromJson(reader1));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedComputeProperties.region = reader.getString();
                    continue;
                }
                if ("cpuCores".equals(fieldName)) {
                    deserializedComputeProperties.cpuCores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("memory".equals(fieldName)) {
                    deserializedComputeProperties.memory = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedComputeProperties.status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedComputeProperties;
        });
    }
}

