/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.ConnectionUriPropertiesInner;
import com.azure.resourcemanager.neonpostgres.fluent.models.ProjectInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.ConnectionUriProperties;
import com.azure.resourcemanager.neonpostgres.models.Project;
import com.azure.resourcemanager.neonpostgres.models.ProjectProperties;

public final class ProjectImpl
implements Project,
Project.Definition,
Project.Update {
    private ProjectInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ProjectProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ProjectInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectImpl withExistingOrganization(String resourceGroupName, String organizationName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        return this;
    }

    @Override
    public Project create() {
        this.innerObject = this.serviceManager.serviceClient().getProjects().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Project create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProjects().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.innerModel(), context);
        return this;
    }

    ProjectImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new ProjectInner();
        this.serviceManager = serviceManager;
        this.projectName = name;
    }

    @Override
    public ProjectImpl update() {
        return this;
    }

    @Override
    public Project apply() {
        this.innerObject = this.serviceManager.serviceClient().getProjects().update(this.resourceGroupName, this.organizationName, this.projectName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Project apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getProjects().update(this.resourceGroupName, this.organizationName, this.projectName, this.innerModel(), context);
        return this;
    }

    ProjectImpl(ProjectInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
    }

    @Override
    public Project refresh() {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Project refresh(Context context) {
        this.innerObject = (ProjectInner)((Object)this.serviceManager.serviceClient().getProjects().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, context).getValue());
        return this;
    }

    @Override
    public Response<ConnectionUriProperties> getConnectionUriWithResponse(ConnectionUriPropertiesInner connectionUriParameters, Context context) {
        return this.serviceManager.projects().getConnectionUriWithResponse(this.resourceGroupName, this.organizationName, this.projectName, connectionUriParameters, context);
    }

    @Override
    public ConnectionUriProperties getConnectionUri(ConnectionUriPropertiesInner connectionUriParameters) {
        return this.serviceManager.projects().getConnectionUri(this.resourceGroupName, this.organizationName, this.projectName, connectionUriParameters);
    }

    @Override
    public ProjectImpl withProperties(ProjectProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

