/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.NeonRolesClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonRoleInner;
import com.azure.resourcemanager.neonpostgres.implementation.NeonRoleImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.NeonRole;
import com.azure.resourcemanager.neonpostgres.models.NeonRoles;

public final class NeonRolesImpl
implements NeonRoles {
    private static final ClientLogger LOGGER = new ClientLogger(NeonRolesImpl.class);
    private final NeonRolesClient innerClient;
    private final NeonPostgresManager serviceManager;

    public NeonRolesImpl(NeonRolesClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NeonRole> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonRoleName, Context context) {
        Response<NeonRoleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NeonRoleImpl((NeonRoleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NeonRole get(String resourceGroupName, String organizationName, String projectName, String branchName, String neonRoleName) {
        NeonRoleInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName, branchName, neonRoleName);
        if (inner != null) {
            return new NeonRoleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonRoleName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName, String neonRoleName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName, branchName, neonRoleName);
    }

    @Override
    public PagedIterable<NeonRole> list(String resourceGroupName, String organizationName, String projectName, String branchName) {
        PagedIterable<NeonRoleInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NeonRoleImpl((NeonRoleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NeonRole> list(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        PagedIterable<NeonRoleInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NeonRoleImpl((NeonRoleInner)((Object)inner1), this.manager()));
    }

    @Override
    public NeonRole getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonRoleName = ResourceManagerUtils.getValueFromIdByName(id, "neonRoles");
        if (neonRoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonRoles'.", id)));
        }
        return (NeonRole)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, Context.NONE).getValue();
    }

    @Override
    public Response<NeonRole> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonRoleName = ResourceManagerUtils.getValueFromIdByName(id, "neonRoles");
        if (neonRoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonRoles'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonRoleName = ResourceManagerUtils.getValueFromIdByName(id, "neonRoles");
        if (neonRoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonRoles'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String neonRoleName = ResourceManagerUtils.getValueFromIdByName(id, "neonRoles");
        if (neonRoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'neonRoles'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonRoleName, context);
    }

    private NeonRolesClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public NeonRoleImpl define(String name) {
        return new NeonRoleImpl(name, this.manager());
    }
}

