/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.neonpostgres.fluent.NeonDatabasesClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonDatabaseInner;
import com.azure.resourcemanager.neonpostgres.implementation.NeonPostgresManagementClientImpl;
import com.azure.resourcemanager.neonpostgres.implementation.models.NeonDatabaseListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NeonDatabasesClientImpl
implements NeonDatabasesClient {
    private final NeonDatabasesService service;
    private final NeonPostgresManagementClientImpl client;

    NeonDatabasesClientImpl(NeonPostgresManagementClientImpl client) {
        this.service = (NeonDatabasesService)RestProxy.create(NeonDatabasesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NeonDatabaseInner>> getWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NeonDatabaseInner>> getWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NeonDatabaseInner> getAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        return this.getWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((NeonDatabaseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NeonDatabaseInner> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NeonDatabaseInner get(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        return (NeonDatabaseInner)((Object)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NeonDatabaseInner.class), (Type)((Object)NeonDatabaseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginCreateOrUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NeonDatabaseInner.class), (Type)((Object)NeonDatabaseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginCreateOrUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginCreateOrUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NeonDatabaseInner> createOrUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NeonDatabaseInner> createOrUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NeonDatabaseInner createOrUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource) {
        return (NeonDatabaseInner)((Object)this.createOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NeonDatabaseInner createOrUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner resource, Context context) {
        return (NeonDatabaseInner)((Object)this.createOrUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, resource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NeonDatabaseInner.class), (Type)((Object)NeonDatabaseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginUpdateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)NeonDatabaseInner.class), (Type)((Object)NeonDatabaseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties) {
        return this.beginUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NeonDatabaseInner>, NeonDatabaseInner> beginUpdate(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NeonDatabaseInner> updateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties) {
        return this.beginUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NeonDatabaseInner> updateAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NeonDatabaseInner update(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties) {
        return (NeonDatabaseInner)((Object)this.updateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NeonDatabaseInner update(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, NeonDatabaseInner properties, Context context) {
        return (NeonDatabaseInner)((Object)this.updateAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, properties, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        if (neonDatabaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter neonDatabaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        return this.deleteWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName, String neonDatabaseName) {
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, neonDatabaseName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NeonDatabaseInner>> listSinglePageAsync(String resourceGroupName, String organizationName, String projectName, String branchName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NeonDatabaseListResult)res.getValue()).value(), ((NeonDatabaseListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NeonDatabaseInner>> listSinglePageAsync(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (organizationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (branchName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter branchName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, organizationName, projectName, branchName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NeonDatabaseListResult)res.getValue()).value(), ((NeonDatabaseListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NeonDatabaseInner> listAsync(String resourceGroupName, String organizationName, String projectName, String branchName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, organizationName, projectName, branchName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<NeonDatabaseInner> listAsync(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, organizationName, projectName, branchName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NeonDatabaseInner> list(String resourceGroupName, String organizationName, String projectName, String branchName) {
        return new PagedIterable(this.listAsync(resourceGroupName, organizationName, projectName, branchName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NeonDatabaseInner> list(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, organizationName, projectName, branchName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NeonDatabaseInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NeonDatabaseListResult)res.getValue()).value(), ((NeonDatabaseListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<NeonDatabaseInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NeonDatabaseListResult)res.getValue()).value(), ((NeonDatabaseListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="NeonPostgresManageme")
    public static interface NeonDatabasesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Neon.Postgres/organizations/{organizationName}/projects/{projectName}/branches/{branchName}/neonDatabases/{neonDatabaseName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NeonDatabaseInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="organizationName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="branchName") String var7, @PathParam(value="neonDatabaseName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Neon.Postgres/organizations/{organizationName}/projects/{projectName}/branches/{branchName}/neonDatabases/{neonDatabaseName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="organizationName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="branchName") String var7, @PathParam(value="neonDatabaseName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") NeonDatabaseInner var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Neon.Postgres/organizations/{organizationName}/projects/{projectName}/branches/{branchName}/neonDatabases/{neonDatabaseName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="organizationName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="branchName") String var7, @PathParam(value="neonDatabaseName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") NeonDatabaseInner var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Neon.Postgres/organizations/{organizationName}/projects/{projectName}/branches/{branchName}/neonDatabases/{neonDatabaseName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="organizationName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="branchName") String var7, @PathParam(value="neonDatabaseName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Neon.Postgres/organizations/{organizationName}/projects/{projectName}/branches/{branchName}/neonDatabases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NeonDatabaseListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="organizationName") String var5, @PathParam(value="projectName") String var6, @PathParam(value="branchName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NeonDatabaseListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

