/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.BranchesClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.BranchInner;
import com.azure.resourcemanager.neonpostgres.implementation.BranchImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Branch;
import com.azure.resourcemanager.neonpostgres.models.Branches;

public final class BranchesImpl
implements Branches {
    private static final ClientLogger LOGGER = new ClientLogger(BranchesImpl.class);
    private final BranchesClient innerClient;
    private final NeonPostgresManager serviceManager;

    public BranchesImpl(BranchesClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Branch> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        Response<BranchInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, branchName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BranchImpl((BranchInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Branch get(String resourceGroupName, String organizationName, String projectName, String branchName) {
        BranchInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName, branchName);
        if (inner != null) {
            return new BranchImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName, branchName);
    }

    @Override
    public PagedIterable<Branch> list(String resourceGroupName, String organizationName, String projectName) {
        PagedIterable<BranchInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BranchImpl((BranchInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Branch> list(String resourceGroupName, String organizationName, String projectName, Context context) {
        PagedIterable<BranchInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BranchImpl((BranchInner)((Object)inner1), this.manager()));
    }

    @Override
    public Branch getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        return (Branch)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, Context.NONE).getValue();
    }

    @Override
    public Response<Branch> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, context);
    }

    private BranchesClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public BranchImpl define(String name) {
        return new BranchImpl(name, this.manager());
    }
}

