/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.fluent.models.UserAssignedIdentityProperties;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class IdentityInner
extends Resource {
    private UserAssignedIdentityProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private UserAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public IdentityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IdentityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityInner fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityInner)((Object)jsonReader.readObject(reader -> {
            IdentityInner deserializedIdentityInner = new IdentityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIdentityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIdentityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentityInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIdentityInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIdentityInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIdentityInner.innerProperties = UserAssignedIdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIdentityInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityInner;
        }));
    }
}

