/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mongodbatlas.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mongodbatlas.models.PartnerProperties;
import com.azure.resourcemanager.mongodbatlas.models.UserDetails;
import java.io.IOException;

public final class OrganizationResourceUpdateProperties
implements JsonSerializable<OrganizationResourceUpdateProperties> {
    private UserDetails user;
    private PartnerProperties partnerProperties;

    public UserDetails user() {
        return this.user;
    }

    public OrganizationResourceUpdateProperties withUser(UserDetails user) {
        this.user = user;
        return this;
    }

    public PartnerProperties partnerProperties() {
        return this.partnerProperties;
    }

    public OrganizationResourceUpdateProperties withPartnerProperties(PartnerProperties partnerProperties) {
        this.partnerProperties = partnerProperties;
        return this;
    }

    public void validate() {
        if (this.user() != null) {
            this.user().validate();
        }
        if (this.partnerProperties() != null) {
            this.partnerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("user", (JsonSerializable)this.user);
        jsonWriter.writeJsonField("partnerProperties", (JsonSerializable)this.partnerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationResourceUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationResourceUpdateProperties)jsonReader.readObject(reader -> {
            OrganizationResourceUpdateProperties deserializedOrganizationResourceUpdateProperties = new OrganizationResourceUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("user".equals(fieldName)) {
                    deserializedOrganizationResourceUpdateProperties.user = UserDetails.fromJson(reader);
                    continue;
                }
                if ("partnerProperties".equals(fieldName)) {
                    deserializedOrganizationResourceUpdateProperties.partnerProperties = PartnerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationResourceUpdateProperties;
        });
    }
}

