/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mongodbatlas.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mongodbatlas.models.ManagedServiceIdentity;
import com.azure.resourcemanager.mongodbatlas.models.OrganizationResourceUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class OrganizationResourceUpdate
implements JsonSerializable<OrganizationResourceUpdate> {
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;
    private OrganizationResourceUpdateProperties properties;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public OrganizationResourceUpdate withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public OrganizationResourceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public OrganizationResourceUpdateProperties properties() {
        return this.properties;
    }

    public OrganizationResourceUpdate withProperties(OrganizationResourceUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationResourceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationResourceUpdate)jsonReader.readObject(reader -> {
            OrganizationResourceUpdate deserializedOrganizationResourceUpdate = new OrganizationResourceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedOrganizationResourceUpdate.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedOrganizationResourceUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOrganizationResourceUpdate.properties = OrganizationResourceUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationResourceUpdate;
        });
    }
}

