/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mongodbatlas.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mongodbatlas.models.MarketplaceDetails;
import com.azure.resourcemanager.mongodbatlas.models.PartnerProperties;
import com.azure.resourcemanager.mongodbatlas.models.ResourceProvisioningState;
import com.azure.resourcemanager.mongodbatlas.models.UserDetails;
import java.io.IOException;

public final class OrganizationProperties
implements JsonSerializable<OrganizationProperties> {
    private MarketplaceDetails marketplace;
    private UserDetails user;
    private ResourceProvisioningState provisioningState;
    private PartnerProperties partnerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(OrganizationProperties.class);

    public MarketplaceDetails marketplace() {
        return this.marketplace;
    }

    public OrganizationProperties withMarketplace(MarketplaceDetails marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public UserDetails user() {
        return this.user;
    }

    public OrganizationProperties withUser(UserDetails user) {
        this.user = user;
        return this;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PartnerProperties partnerProperties() {
        return this.partnerProperties;
    }

    public OrganizationProperties withPartnerProperties(PartnerProperties partnerProperties) {
        this.partnerProperties = partnerProperties;
        return this;
    }

    public void validate() {
        if (this.marketplace() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property marketplace in model OrganizationProperties"));
        }
        this.marketplace().validate();
        if (this.user() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property user in model OrganizationProperties"));
        }
        this.user().validate();
        if (this.partnerProperties() != null) {
            this.partnerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("marketplace", (JsonSerializable)this.marketplace);
        jsonWriter.writeJsonField("user", (JsonSerializable)this.user);
        jsonWriter.writeJsonField("partnerProperties", (JsonSerializable)this.partnerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationProperties)jsonReader.readObject(reader -> {
            OrganizationProperties deserializedOrganizationProperties = new OrganizationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("marketplace".equals(fieldName)) {
                    deserializedOrganizationProperties.marketplace = MarketplaceDetails.fromJson(reader);
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedOrganizationProperties.user = UserDetails.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOrganizationProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("partnerProperties".equals(fieldName)) {
                    deserializedOrganizationProperties.partnerProperties = PartnerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationProperties;
        });
    }
}

