/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.Workspace;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspacePatch;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WorkspaceImpl
implements Workspace,
Workspace.Definition,
Workspace.Update {
    private WorkspaceInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private WorkspacePatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public WorkspaceEntityStatus provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String customerId() {
        return this.innerModel().customerId();
    }

    @Override
    public WorkspaceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public Integer retentionInDays() {
        return this.innerModel().retentionInDays();
    }

    @Override
    public WorkspaceCapping workspaceCapping() {
        return this.innerModel().workspaceCapping();
    }

    @Override
    public String createdDate() {
        return this.innerModel().createdDate();
    }

    @Override
    public String modifiedDate() {
        return this.innerModel().modifiedDate();
    }

    @Override
    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.innerModel().publicNetworkAccessForIngestion();
    }

    @Override
    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.innerModel().publicNetworkAccessForQuery();
    }

    @Override
    public Boolean forceCmkForQuery() {
        return this.innerModel().forceCmkForQuery();
    }

    @Override
    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        List<PrivateLinkScopedResource> inner = this.innerModel().privateLinkScopedResources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public WorkspaceFeatures features() {
        return this.innerModel().features();
    }

    @Override
    public String defaultDataCollectionRuleResourceId() {
        return this.innerModel().defaultDataCollectionRuleResourceId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkspaceInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Workspace create() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdate(this.resourceGroupName, this.workspaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Workspace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdate(this.resourceGroupName, this.workspaceName, this.innerModel(), context);
        return this;
    }

    WorkspaceImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new WorkspaceInner();
        this.serviceManager = serviceManager;
        this.workspaceName = name;
    }

    @Override
    public WorkspaceImpl update() {
        this.updateParameters = new WorkspacePatch();
        return this;
    }

    @Override
    public Workspace apply() {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.workspaceName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workspace apply(Context context) {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.workspaceName, this.updateParameters, context).getValue());
        return this;
    }

    WorkspaceImpl(WorkspaceInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = Utils.getValueFromIdByName(innerObject.id(), "workspaces");
    }

    @Override
    public Workspace refresh() {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workspace refresh(Context context) {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, context).getValue());
        return this;
    }

    @Override
    public WorkspaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WorkspaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WorkspaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public WorkspaceImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public WorkspaceImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public WorkspaceImpl withSku(WorkspaceSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public WorkspaceImpl withRetentionInDays(Integer retentionInDays) {
        if (this.isInCreateMode()) {
            this.innerModel().withRetentionInDays(retentionInDays);
            return this;
        }
        this.updateParameters.withRetentionInDays(retentionInDays);
        return this;
    }

    @Override
    public WorkspaceImpl withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        if (this.isInCreateMode()) {
            this.innerModel().withWorkspaceCapping(workspaceCapping);
            return this;
        }
        this.updateParameters.withWorkspaceCapping(workspaceCapping);
        return this;
    }

    @Override
    public WorkspaceImpl withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
            return this;
        }
        this.updateParameters.withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
        return this;
    }

    @Override
    public WorkspaceImpl withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
            return this;
        }
        this.updateParameters.withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
        return this;
    }

    @Override
    public WorkspaceImpl withForceCmkForQuery(Boolean forceCmkForQuery) {
        if (this.isInCreateMode()) {
            this.innerModel().withForceCmkForQuery(forceCmkForQuery);
            return this;
        }
        this.updateParameters.withForceCmkForQuery(forceCmkForQuery);
        return this;
    }

    @Override
    public WorkspaceImpl withFeatures(WorkspaceFeatures features) {
        if (this.isInCreateMode()) {
            this.innerModel().withFeatures(features);
            return this;
        }
        this.updateParameters.withFeatures(features);
        return this;
    }

    @Override
    public WorkspaceImpl withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        if (this.isInCreateMode()) {
            this.innerModel().withDefaultDataCollectionRuleResourceId(defaultDataCollectionRuleResourceId);
            return this;
        }
        this.updateParameters.withDefaultDataCollectionRuleResourceId(defaultDataCollectionRuleResourceId);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

