/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.SharedKeysOperationsClient;
import com.azure.resourcemanager.loganalytics.fluent.models.SharedKeysInner;
import com.azure.resourcemanager.loganalytics.implementation.SharedKeysImpl;
import com.azure.resourcemanager.loganalytics.models.SharedKeys;
import com.azure.resourcemanager.loganalytics.models.SharedKeysOperations;

public final class SharedKeysOperationsImpl
implements SharedKeysOperations {
    private static final ClientLogger LOGGER = new ClientLogger(SharedKeysOperationsImpl.class);
    private final SharedKeysOperationsClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public SharedKeysOperationsImpl(SharedKeysOperationsClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SharedKeys> getSharedKeysWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<SharedKeysInner> inner = this.serviceClient().getSharedKeysWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SharedKeysImpl((SharedKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SharedKeys getSharedKeys(String resourceGroupName, String workspaceName) {
        SharedKeysInner inner = this.serviceClient().getSharedKeys(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SharedKeysImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SharedKeys> regenerateWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<SharedKeysInner> inner = this.serviceClient().regenerateWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SharedKeysImpl((SharedKeysInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SharedKeys regenerate(String resourceGroupName, String workspaceName) {
        SharedKeysInner inner = this.serviceClient().regenerate(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SharedKeysImpl(inner, this.manager());
        }
        return null;
    }

    private SharedKeysOperationsClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

