/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.SavedSearch;
import com.azure.resourcemanager.loganalytics.models.Tag;
import java.util.Collections;
import java.util.List;

public final class SavedSearchImpl
implements SavedSearch,
SavedSearch.Definition,
SavedSearch.Update {
    private SavedSearchInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String savedSearchId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String category() {
        return this.innerModel().category();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String query() {
        return this.innerModel().query();
    }

    @Override
    public String functionAlias() {
        return this.innerModel().functionAlias();
    }

    @Override
    public String functionParameters() {
        return this.innerModel().functionParameters();
    }

    @Override
    public Long version() {
        return this.innerModel().version();
    }

    @Override
    public List<Tag> tags() {
        List<Tag> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SavedSearchInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public SavedSearchImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public SavedSearch create() {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SavedSearch create(Context context) {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, this.innerModel(), context).getValue());
        return this;
    }

    SavedSearchImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new SavedSearchInner();
        this.serviceManager = serviceManager;
        this.savedSearchId = name;
    }

    @Override
    public SavedSearchImpl update() {
        return this;
    }

    @Override
    public SavedSearch apply() {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SavedSearch apply(Context context) {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().createOrUpdateWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, this.innerModel(), context).getValue());
        return this;
    }

    SavedSearchImpl(SavedSearchInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.workspaceName = Utils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.savedSearchId = Utils.getValueFromIdByName(innerObject.id(), "savedSearches");
    }

    @Override
    public SavedSearch refresh() {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().getWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, Context.NONE).getValue());
        return this;
    }

    @Override
    public SavedSearch refresh(Context context) {
        this.innerObject = (SavedSearchInner)((Object)this.serviceManager.serviceClient().getSavedSearches().getWithResponse(this.resourceGroupName, this.workspaceName, this.savedSearchId, context).getValue());
        return this;
    }

    @Override
    public SavedSearchImpl withCategory(String category) {
        this.innerModel().withCategory(category);
        return this;
    }

    @Override
    public SavedSearchImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public SavedSearchImpl withQuery(String query) {
        this.innerModel().withQuery(query);
        return this;
    }

    @Override
    public SavedSearchImpl withTags(List<Tag> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public SavedSearchImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public SavedSearchImpl withFunctionAlias(String functionAlias) {
        this.innerModel().withFunctionAlias(functionAlias);
        return this;
    }

    @Override
    public SavedSearchImpl withFunctionParameters(String functionParameters) {
        this.innerModel().withFunctionParameters(functionParameters);
        return this;
    }

    @Override
    public SavedSearchImpl withVersion(Long version) {
        this.innerModel().withVersion(version);
        return this;
    }
}

