/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.QueryPacksClient;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackInner;
import com.azure.resourcemanager.loganalytics.implementation.LogAnalyticsQueryPackImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPack;
import com.azure.resourcemanager.loganalytics.models.QueryPacks;

public final class QueryPacksImpl
implements QueryPacks {
    private static final ClientLogger LOGGER = new ClientLogger(QueryPacksImpl.class);
    private final QueryPacksClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public QueryPacksImpl(QueryPacksClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPack> list() {
        PagedIterable<LogAnalyticsQueryPackInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPack> list(Context context) {
        PagedIterable<LogAnalyticsQueryPackInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPack> listByResourceGroup(String resourceGroupName) {
        PagedIterable<LogAnalyticsQueryPackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPack> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<LogAnalyticsQueryPackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<LogAnalyticsQueryPack> createOrUpdateWithoutNameWithResponse(String resourceGroupName, LogAnalyticsQueryPackInner logAnalyticsQueryPackPayload, Context context) {
        Response<LogAnalyticsQueryPackInner> inner = this.serviceClient().createOrUpdateWithoutNameWithResponse(resourceGroupName, logAnalyticsQueryPackPayload, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LogAnalyticsQueryPack createOrUpdateWithoutName(String resourceGroupName, LogAnalyticsQueryPackInner logAnalyticsQueryPackPayload) {
        LogAnalyticsQueryPackInner inner = this.serviceClient().createOrUpdateWithoutName(resourceGroupName, logAnalyticsQueryPackPayload);
        if (inner != null) {
            return new LogAnalyticsQueryPackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String queryPackName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, queryPackName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String queryPackName) {
        this.serviceClient().delete(resourceGroupName, queryPackName);
    }

    @Override
    public Response<LogAnalyticsQueryPack> getByResourceGroupWithResponse(String resourceGroupName, String queryPackName, Context context) {
        Response<LogAnalyticsQueryPackInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, queryPackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LogAnalyticsQueryPackImpl((LogAnalyticsQueryPackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LogAnalyticsQueryPack getByResourceGroup(String resourceGroupName, String queryPackName) {
        LogAnalyticsQueryPackInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, queryPackName);
        if (inner != null) {
            return new LogAnalyticsQueryPackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public LogAnalyticsQueryPack getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        return (LogAnalyticsQueryPack)this.getByResourceGroupWithResponse(resourceGroupName, queryPackName, Context.NONE).getValue();
    }

    @Override
    public Response<LogAnalyticsQueryPack> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, queryPackName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, queryPackName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, queryPackName, context);
    }

    private QueryPacksClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogAnalyticsQueryPackImpl define(String name) {
        return new LogAnalyticsQueryPackImpl(name, this.manager());
    }
}

