/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.AvailableServiceTiersClient;
import com.azure.resourcemanager.loganalytics.fluent.models.AvailableServiceTierInner;
import com.azure.resourcemanager.loganalytics.implementation.AvailableServiceTierImpl;
import com.azure.resourcemanager.loganalytics.models.AvailableServiceTier;
import com.azure.resourcemanager.loganalytics.models.AvailableServiceTiers;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class AvailableServiceTiersImpl
implements AvailableServiceTiers {
    private static final ClientLogger LOGGER = new ClientLogger(AvailableServiceTiersImpl.class);
    private final AvailableServiceTiersClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public AvailableServiceTiersImpl(AvailableServiceTiersClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<List<AvailableServiceTier>> listByWorkspaceWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<List<AvailableServiceTierInner>> inner = this.serviceClient().listByWorkspaceWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new AvailableServiceTierImpl((AvailableServiceTierInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public List<AvailableServiceTier> listByWorkspace(String resourceGroupName, String workspaceName) {
        List<AvailableServiceTierInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new AvailableServiceTierImpl((AvailableServiceTierInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private AvailableServiceTiersClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

