/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.models.DestinationMetadata;
import com.azure.resourcemanager.loganalytics.models.Type;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Destination {
    @JsonProperty(value="resourceId", required=true)
    private String resourceId;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private Type type;
    @JsonProperty(value="metaData")
    private DestinationMetadata innerMetadata;
    private static final ClientLogger LOGGER = new ClientLogger(Destination.class);

    public String resourceId() {
        return this.resourceId;
    }

    public Destination withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Type type() {
        return this.type;
    }

    private DestinationMetadata innerMetadata() {
        return this.innerMetadata;
    }

    public String eventHubName() {
        return this.innerMetadata() == null ? null : this.innerMetadata().eventHubName();
    }

    public Destination withEventHubName(String eventHubName) {
        if (this.innerMetadata() == null) {
            this.innerMetadata = new DestinationMetadata();
        }
        this.innerMetadata().withEventHubName(eventHubName);
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model Destination"));
        }
        if (this.innerMetadata() != null) {
            this.innerMetadata().validate();
        }
    }
}

