/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.resourcemanager.loganalytics.models.Column;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SourceEnum;
import com.azure.resourcemanager.loganalytics.models.TableSubTypeEnum;
import com.azure.resourcemanager.loganalytics.models.TableTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Schema {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="columns")
    private List<Column> columns;
    @JsonProperty(value="standardColumns", access=JsonProperty.Access.WRITE_ONLY)
    private List<Column> standardColumns;
    @JsonProperty(value="categories", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> categories;
    @JsonProperty(value="labels", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> labels;
    @JsonProperty(value="source", access=JsonProperty.Access.WRITE_ONLY)
    private SourceEnum source;
    @JsonProperty(value="tableType", access=JsonProperty.Access.WRITE_ONLY)
    private TableTypeEnum tableType;
    @JsonProperty(value="tableSubType", access=JsonProperty.Access.WRITE_ONLY)
    private TableSubTypeEnum tableSubType;
    @JsonProperty(value="solutions", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> solutions;
    @JsonProperty(value="searchResults", access=JsonProperty.Access.WRITE_ONLY)
    private SearchResults searchResults;
    @JsonProperty(value="restoredLogs", access=JsonProperty.Access.WRITE_ONLY)
    private RestoredLogs restoredLogs;

    public String name() {
        return this.name;
    }

    public Schema withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public Schema withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Schema withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Column> columns() {
        return this.columns;
    }

    public Schema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public List<Column> standardColumns() {
        return this.standardColumns;
    }

    public List<String> categories() {
        return this.categories;
    }

    public List<String> labels() {
        return this.labels;
    }

    public SourceEnum source() {
        return this.source;
    }

    public TableTypeEnum tableType() {
        return this.tableType;
    }

    public TableSubTypeEnum tableSubType() {
        return this.tableSubType;
    }

    public List<String> solutions() {
        return this.solutions;
    }

    public SearchResults searchResults() {
        return this.searchResults;
    }

    public RestoredLogs restoredLogs() {
        return this.restoredLogs;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
        if (this.standardColumns() != null) {
            this.standardColumns().forEach(e -> e.validate());
        }
        if (this.searchResults() != null) {
            this.searchResults().validate();
        }
        if (this.restoredLogs() != null) {
            this.restoredLogs().validate();
        }
    }
}

