/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.SavedSearchesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchInner;
import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchesListResultInner;
import com.azure.resourcemanager.loganalytics.implementation.SavedSearchImpl;
import com.azure.resourcemanager.loganalytics.implementation.SavedSearchesListResultImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.SavedSearch;
import com.azure.resourcemanager.loganalytics.models.SavedSearches;
import com.azure.resourcemanager.loganalytics.models.SavedSearchesListResult;

public final class SavedSearchesImpl
implements SavedSearches {
    private static final ClientLogger LOGGER = new ClientLogger(SavedSearchesImpl.class);
    private final SavedSearchesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public SavedSearchesImpl(SavedSearchesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String savedSearchId) {
        this.serviceClient().delete(resourceGroupName, workspaceName, savedSearchId);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String workspaceName, String savedSearchId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, workspaceName, savedSearchId, context);
    }

    @Override
    public SavedSearch get(String resourceGroupName, String workspaceName, String savedSearchId) {
        SavedSearchInner inner = this.serviceClient().get(resourceGroupName, workspaceName, savedSearchId);
        if (inner != null) {
            return new SavedSearchImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SavedSearch> getWithResponse(String resourceGroupName, String workspaceName, String savedSearchId, Context context) {
        Response<SavedSearchInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, savedSearchId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SavedSearchImpl((SavedSearchInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SavedSearchesListResult listByWorkspace(String resourceGroupName, String workspaceName) {
        SavedSearchesListResultInner inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SavedSearchesListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SavedSearchesListResult> listByWorkspaceWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<SavedSearchesListResultInner> inner = this.serviceClient().listByWorkspaceWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SavedSearchesListResultImpl((SavedSearchesListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SavedSearch getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String savedSearchId = Utils.getValueFromIdByName(id, "savedSearches");
        if (savedSearchId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'savedSearches'.", id)));
        }
        return (SavedSearch)this.getWithResponse(resourceGroupName, workspaceName, savedSearchId, Context.NONE).getValue();
    }

    @Override
    public Response<SavedSearch> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String savedSearchId = Utils.getValueFromIdByName(id, "savedSearches");
        if (savedSearchId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'savedSearches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, savedSearchId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String savedSearchId = Utils.getValueFromIdByName(id, "savedSearches");
        if (savedSearchId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'savedSearches'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, workspaceName, savedSearchId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String savedSearchId = Utils.getValueFromIdByName(id, "savedSearches");
        if (savedSearchId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'savedSearches'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, workspaceName, savedSearchId, context);
    }

    private SavedSearchesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public SavedSearchImpl define(String name) {
        return new SavedSearchImpl(name, this.manager());
    }
}

