/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.OperationStatusesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import reactor.core.publisher.Mono;

public final class OperationStatusesClientImpl
implements OperationStatusesClient {
    private final OperationStatusesService service;
    private final OperationalInsightsManagementClientImpl client;

    OperationStatusesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (OperationStatusesService)RestProxy.create(OperationStatusesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OperationStatusInner>> getWithResponseAsync(String location, String asyncOperationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (asyncOperationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter asyncOperationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, asyncOperationId, "2020-08-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OperationStatusInner>> getWithResponseAsync(String location, String asyncOperationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (asyncOperationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter asyncOperationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, asyncOperationId, "2020-08-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusInner> getAsync(String location, String asyncOperationId) {
        return this.getWithResponseAsync(location, asyncOperationId).flatMap(res -> Mono.justOrEmpty((Object)((OperationStatusInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner get(String location, String asyncOperationId) {
        return (OperationStatusInner)this.getAsync(location, asyncOperationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationStatusInner> getWithResponse(String location, String asyncOperationId, Context context) {
        return (Response)this.getWithResponseAsync(location, asyncOperationId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    private static interface OperationStatusesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.OperationalInsights/locations/{location}/operationStatuses/{asyncOperationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationStatusInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="asyncOperationId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

