/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.Cluster;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.ClusterPatch;
import com.azure.resourcemanager.loganalytics.models.ClusterSku;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ClusterImpl
implements Cluster,
Cluster.Definition,
Cluster.Update {
    private ClusterInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private ClusterPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public ClusterSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public ClusterEntityStatus provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Boolean isDoubleEncryptionEnabled() {
        return this.innerModel().isDoubleEncryptionEnabled();
    }

    @Override
    public Boolean isAvailabilityZonesEnabled() {
        return this.innerModel().isAvailabilityZonesEnabled();
    }

    @Override
    public BillingType billingType() {
        return this.innerModel().billingType();
    }

    @Override
    public KeyVaultProperties keyVaultProperties() {
        return this.innerModel().keyVaultProperties();
    }

    @Override
    public String lastModifiedDate() {
        return this.innerModel().lastModifiedDate();
    }

    @Override
    public String createdDate() {
        return this.innerModel().createdDate();
    }

    @Override
    public List<AssociatedWorkspace> associatedWorkspaces() {
        List<AssociatedWorkspace> inner = this.innerModel().associatedWorkspaces();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public CapacityReservationProperties capacityReservationProperties() {
        return this.innerModel().capacityReservationProperties();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Cluster create() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Cluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), context);
        return this;
    }

    ClusterImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new ClusterInner();
        this.serviceManager = serviceManager;
        this.clusterName = name;
    }

    @Override
    public ClusterImpl update() {
        this.updateParameters = new ClusterPatch();
        return this;
    }

    @Override
    public Cluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Cluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateParameters, context);
        return this;
    }

    ClusterImpl(ClusterInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourcegroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
    }

    @Override
    public Cluster refresh() {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cluster refresh(Context context) {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, context).getValue());
        return this;
    }

    @Override
    public ClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ClusterImpl withSku(ClusterSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ClusterImpl withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        this.innerModel().withIsDoubleEncryptionEnabled(isDoubleEncryptionEnabled);
        return this;
    }

    @Override
    public ClusterImpl withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        this.innerModel().withIsAvailabilityZonesEnabled(isAvailabilityZonesEnabled);
        return this;
    }

    @Override
    public ClusterImpl withBillingType(BillingType billingType) {
        if (this.isInCreateMode()) {
            this.innerModel().withBillingType(billingType);
            return this;
        }
        this.updateParameters.withBillingType(billingType);
        return this;
    }

    @Override
    public ClusterImpl withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.isInCreateMode()) {
            this.innerModel().withKeyVaultProperties(keyVaultProperties);
            return this;
        }
        this.updateParameters.withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    @Override
    public ClusterImpl withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        this.innerModel().withAssociatedWorkspaces(associatedWorkspaces);
        return this;
    }

    @Override
    public ClusterImpl withCapacityReservationProperties(CapacityReservationProperties capacityReservationProperties) {
        this.innerModel().withCapacityReservationProperties(capacityReservationProperties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

