/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.models.DataSourceKind;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class DataSourceInner
extends ProxyResource {
    @JsonProperty(value="properties", required=true)
    private Object properties;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="kind", required=true)
    private DataSourceKind kind;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(DataSourceInner.class);

    public Object properties() {
        return this.properties;
    }

    public DataSourceInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public DataSourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public DataSourceKind kind() {
        return this.kind;
    }

    public DataSourceInner withKind(DataSourceKind kind) {
        this.kind = kind;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DataSourceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property properties in model DataSourceInner"));
        }
        if (this.kind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kind in model DataSourceInner"));
        }
    }
}

