// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SKU (tier) of a workspace. */
@Fluent
public final class WorkspaceSku {
    /*
     * The name of the SKU.
     */
    @JsonProperty(value = "name", required = true)
    private WorkspaceSkuNameEnum name;

    /*
     * The capacity reservation level in GB for this workspace, when
     * CapacityReservation sku is selected.
     */
    @JsonProperty(value = "capacityReservationLevel")
    private CapacityReservationLevel capacityReservationLevel;

    /*
     * The last time when the sku was updated.
     */
    @JsonProperty(value = "lastSkuUpdate", access = JsonProperty.Access.WRITE_ONLY)
    private String lastSkuUpdate;

    /**
     * Get the name property: The name of the SKU.
     *
     * @return the name value.
     */
    public WorkspaceSkuNameEnum name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the SKU.
     *
     * @param name the name value to set.
     * @return the WorkspaceSku object itself.
     */
    public WorkspaceSku withName(WorkspaceSkuNameEnum name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capacityReservationLevel property: The capacity reservation level in GB for this workspace, when
     * CapacityReservation sku is selected.
     *
     * @return the capacityReservationLevel value.
     */
    public CapacityReservationLevel capacityReservationLevel() {
        return this.capacityReservationLevel;
    }

    /**
     * Set the capacityReservationLevel property: The capacity reservation level in GB for this workspace, when
     * CapacityReservation sku is selected.
     *
     * @param capacityReservationLevel the capacityReservationLevel value to set.
     * @return the WorkspaceSku object itself.
     */
    public WorkspaceSku withCapacityReservationLevel(CapacityReservationLevel capacityReservationLevel) {
        this.capacityReservationLevel = capacityReservationLevel;
        return this;
    }

    /**
     * Get the lastSkuUpdate property: The last time when the sku was updated.
     *
     * @return the lastSkuUpdate value.
     */
    public String lastSkuUpdate() {
        return this.lastSkuUpdate;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model WorkspaceSku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceSku.class);
}
