// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of SharedKeysOperations. */
public interface SharedKeysOperations {
    /**
     * Gets the shared keys for a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace.
     */
    SharedKeys getSharedKeys(String resourceGroupName, String workspaceName);

    /**
     * Gets the shared keys for a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace along with {@link Response}.
     */
    Response<SharedKeys> getSharedKeysWithResponse(String resourceGroupName, String workspaceName, Context context);

    /**
     * Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational
     * Insights agents to the workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace.
     */
    SharedKeys regenerate(String resourceGroupName, String workspaceName);

    /**
     * Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational
     * Insights agents to the workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace along with {@link Response}.
     */
    Response<SharedKeys> regenerateWithResponse(String resourceGroupName, String workspaceName, Context context);
}
