// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Parameters of the search job that initiated this table. */
@Fluent
public final class SearchResults {
    /*
     * Search job query.
     */
    @JsonProperty(value = "query")
    private String query;

    /*
     * Search job Description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Limit the search job to return up to specified number of rows.
     */
    @JsonProperty(value = "limit")
    private Integer limit;

    /*
     * The timestamp to start the search from (UTC)
     */
    @JsonProperty(value = "startSearchTime")
    private OffsetDateTime startSearchTime;

    /*
     * The timestamp to end the search by (UTC)
     */
    @JsonProperty(value = "endSearchTime")
    private OffsetDateTime endSearchTime;

    /*
     * The table used in the search job.
     */
    @JsonProperty(value = "sourceTable", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceTable;

    /**
     * Get the query property: Search job query.
     *
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: Search job query.
     *
     * @param query the query value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the description property: Search job Description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Search job Description.
     *
     * @param description the description value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the limit property: Limit the search job to return up to specified number of rows.
     *
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Set the limit property: Limit the search job to return up to specified number of rows.
     *
     * @param limit the limit value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the startSearchTime property: The timestamp to start the search from (UTC).
     *
     * @return the startSearchTime value.
     */
    public OffsetDateTime startSearchTime() {
        return this.startSearchTime;
    }

    /**
     * Set the startSearchTime property: The timestamp to start the search from (UTC).
     *
     * @param startSearchTime the startSearchTime value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withStartSearchTime(OffsetDateTime startSearchTime) {
        this.startSearchTime = startSearchTime;
        return this;
    }

    /**
     * Get the endSearchTime property: The timestamp to end the search by (UTC).
     *
     * @return the endSearchTime value.
     */
    public OffsetDateTime endSearchTime() {
        return this.endSearchTime;
    }

    /**
     * Set the endSearchTime property: The timestamp to end the search by (UTC).
     *
     * @param endSearchTime the endSearchTime value to set.
     * @return the SearchResults object itself.
     */
    public SearchResults withEndSearchTime(OffsetDateTime endSearchTime) {
        this.endSearchTime = endSearchTime;
        return this;
    }

    /**
     * Get the sourceTable property: The table used in the search job.
     *
     * @return the sourceTable value.
     */
    public String sourceTable() {
        return this.sourceTable;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
