// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedStorageAccountsResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list linked storage accounts service operation response. */
@Fluent
public final class LinkedStorageAccountsListResult {
    /*
     * A list of linked storage accounts instances.
     */
    @JsonProperty(value = "value")
    private List<LinkedStorageAccountsResourceInner> value;

    /**
     * Get the value property: A list of linked storage accounts instances.
     *
     * @return the value value.
     */
    public List<LinkedStorageAccountsResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of linked storage accounts instances.
     *
     * @param value the value value to set.
     * @return the LinkedStorageAccountsListResult object itself.
     */
    public LinkedStorageAccountsListResult withValue(List<LinkedStorageAccountsResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
