// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchInner;
import com.azure.resourcemanager.loganalytics.fluent.models.SavedSearchesListResultInner;
import com.azure.resourcemanager.loganalytics.models.SavedSearch;
import com.azure.resourcemanager.loganalytics.models.SavedSearchesListResult;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SavedSearchesListResultImpl implements SavedSearchesListResult {
    private SavedSearchesListResultInner innerObject;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    SavedSearchesListResultImpl(
        SavedSearchesListResultInner innerObject,
        com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<SavedSearch> value() {
        List<SavedSearchInner> inner = this.innerModel().value();
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new SavedSearchImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public SavedSearchesListResultInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}
