// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** Properties that define an Log Analytics QueryPack-Query resource. */
@Fluent
public final class LogAnalyticsQueryPackQueryProperties {
    /*
     * The unique ID of your application. This field cannot be changed.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Unique display name for your query within the Query Pack.
     */
    @JsonProperty(value = "displayName", required = true)
    private String displayName;

    /*
     * Creation Date for the Log Analytics Query, in ISO 8601 format.
     */
    @JsonProperty(value = "timeCreated", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;

    /*
     * Last modified date of the Log Analytics Query, in ISO 8601 format.
     */
    @JsonProperty(value = "timeModified", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeModified;

    /*
     * Object Id of user creating the query.
     */
    @JsonProperty(value = "author", access = JsonProperty.Access.WRITE_ONLY)
    private String author;

    /*
     * Description of the query.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Body of the query.
     */
    @JsonProperty(value = "body", required = true)
    private String body;

    /*
     * The related metadata items for the function.
     */
    @JsonProperty(value = "related")
    private LogAnalyticsQueryPackQueryPropertiesRelated related;

    /*
     * Tags associated with the query.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, List<String>> tags;

    /*
     * Additional properties that can be set for the query.
     */
    @JsonProperty(value = "properties")
    private Object properties;

    /**
     * Get the id property: The unique ID of your application. This field cannot be changed.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Unique display name for your query within the Query Pack.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Unique display name for your query within the Query Pack.
     *
     * @param displayName the displayName value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the timeCreated property: Creation Date for the Log Analytics Query, in ISO 8601 format.
     *
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the timeModified property: Last modified date of the Log Analytics Query, in ISO 8601 format.
     *
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    /**
     * Get the author property: Object Id of user creating the query.
     *
     * @return the author value.
     */
    public String author() {
        return this.author;
    }

    /**
     * Get the description property: Description of the query.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the query.
     *
     * @param description the description value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the body property: Body of the query.
     *
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the query.
     *
     * @param body the body value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Get the related property: The related metadata items for the function.
     *
     * @return the related value.
     */
    public LogAnalyticsQueryPackQueryPropertiesRelated related() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the function.
     *
     * @param related the related value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withRelated(LogAnalyticsQueryPackQueryPropertiesRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Get the tags property: Tags associated with the query.
     *
     * @return the tags value.
     */
    public Map<String, List<String>> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags associated with the query.
     *
     * @param tags the tags value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withTags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: Additional properties that can be set for the query.
     *
     * @return the properties value.
     */
    public Object properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional properties that can be set for the query.
     *
     * @param properties the properties value to set.
     * @return the LogAnalyticsQueryPackQueryProperties object itself.
     */
    public LogAnalyticsQueryPackQueryProperties withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property displayName in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (body() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property body in model LogAnalyticsQueryPackQueryProperties"));
        }
        if (related() != null) {
            related().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogAnalyticsQueryPackQueryProperties.class);
}
