// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Cluster properties. */
@Fluent
public final class ClusterProperties {
    /*
     * The ID associated with the cluster.
     */
    @JsonProperty(value = "clusterId", access = JsonProperty.Access.WRITE_ONLY)
    private String clusterId;

    /*
     * The provisioning state of the cluster.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ClusterEntityStatus provisioningState;

    /*
     * Configures whether cluster will use double encryption. This Property can
     * not be modified after cluster creation. Default value is 'true'
     */
    @JsonProperty(value = "isDoubleEncryptionEnabled")
    private Boolean isDoubleEncryptionEnabled;

    /*
     * Sets whether the cluster will support availability zones. This can be
     * set as true only in regions where Azure Data Explorer support
     * Availability Zones. This Property can not be modified after cluster
     * creation. Default value is 'true' if region supports Availability Zones.
     */
    @JsonProperty(value = "isAvailabilityZonesEnabled")
    private Boolean isAvailabilityZonesEnabled;

    /*
     * The cluster's billing type.
     */
    @JsonProperty(value = "billingType")
    private BillingType billingType;

    /*
     * The associated key properties.
     */
    @JsonProperty(value = "keyVaultProperties")
    private KeyVaultProperties keyVaultProperties;

    /*
     * The last time the cluster was updated.
     */
    @JsonProperty(value = "lastModifiedDate", access = JsonProperty.Access.WRITE_ONLY)
    private String lastModifiedDate;

    /*
     * The cluster creation time
     */
    @JsonProperty(value = "createdDate", access = JsonProperty.Access.WRITE_ONLY)
    private String createdDate;

    /*
     * The list of Log Analytics workspaces associated with the cluster
     */
    @JsonProperty(value = "associatedWorkspaces")
    private List<AssociatedWorkspace> associatedWorkspaces;

    /*
     * Additional properties for capacity reservation
     */
    @JsonProperty(value = "capacityReservationProperties")
    private CapacityReservationProperties capacityReservationProperties;

    /**
     * Get the clusterId property: The ID associated with the cluster.
     *
     * @return the clusterId value.
     */
    public String clusterId() {
        return this.clusterId;
    }

    /**
     * Get the provisioningState property: The provisioning state of the cluster.
     *
     * @return the provisioningState value.
     */
    public ClusterEntityStatus provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the isDoubleEncryptionEnabled property: Configures whether cluster will use double encryption. This Property
     * can not be modified after cluster creation. Default value is 'true'.
     *
     * @return the isDoubleEncryptionEnabled value.
     */
    public Boolean isDoubleEncryptionEnabled() {
        return this.isDoubleEncryptionEnabled;
    }

    /**
     * Set the isDoubleEncryptionEnabled property: Configures whether cluster will use double encryption. This Property
     * can not be modified after cluster creation. Default value is 'true'.
     *
     * @param isDoubleEncryptionEnabled the isDoubleEncryptionEnabled value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        this.isDoubleEncryptionEnabled = isDoubleEncryptionEnabled;
        return this;
    }

    /**
     * Get the isAvailabilityZonesEnabled property: Sets whether the cluster will support availability zones. This can
     * be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be
     * modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     *
     * @return the isAvailabilityZonesEnabled value.
     */
    public Boolean isAvailabilityZonesEnabled() {
        return this.isAvailabilityZonesEnabled;
    }

    /**
     * Set the isAvailabilityZonesEnabled property: Sets whether the cluster will support availability zones. This can
     * be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be
     * modified after cluster creation. Default value is 'true' if region supports Availability Zones.
     *
     * @param isAvailabilityZonesEnabled the isAvailabilityZonesEnabled value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        this.isAvailabilityZonesEnabled = isAvailabilityZonesEnabled;
        return this;
    }

    /**
     * Get the billingType property: The cluster's billing type.
     *
     * @return the billingType value.
     */
    public BillingType billingType() {
        return this.billingType;
    }

    /**
     * Set the billingType property: The cluster's billing type.
     *
     * @param billingType the billingType value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withBillingType(BillingType billingType) {
        this.billingType = billingType;
        return this;
    }

    /**
     * Get the keyVaultProperties property: The associated key properties.
     *
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: The associated key properties.
     *
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Get the lastModifiedDate property: The last time the cluster was updated.
     *
     * @return the lastModifiedDate value.
     */
    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    /**
     * Get the createdDate property: The cluster creation time.
     *
     * @return the createdDate value.
     */
    public String createdDate() {
        return this.createdDate;
    }

    /**
     * Get the associatedWorkspaces property: The list of Log Analytics workspaces associated with the cluster.
     *
     * @return the associatedWorkspaces value.
     */
    public List<AssociatedWorkspace> associatedWorkspaces() {
        return this.associatedWorkspaces;
    }

    /**
     * Set the associatedWorkspaces property: The list of Log Analytics workspaces associated with the cluster.
     *
     * @param associatedWorkspaces the associatedWorkspaces value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        this.associatedWorkspaces = associatedWorkspaces;
        return this;
    }

    /**
     * Get the capacityReservationProperties property: Additional properties for capacity reservation.
     *
     * @return the capacityReservationProperties value.
     */
    public CapacityReservationProperties capacityReservationProperties() {
        return this.capacityReservationProperties;
    }

    /**
     * Set the capacityReservationProperties property: Additional properties for capacity reservation.
     *
     * @param capacityReservationProperties the capacityReservationProperties value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withCapacityReservationProperties(
        CapacityReservationProperties capacityReservationProperties) {
        this.capacityReservationProperties = capacityReservationProperties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
        if (associatedWorkspaces() != null) {
            associatedWorkspaces().forEach(e -> e.validate());
        }
        if (capacityReservationProperties() != null) {
            capacityReservationProperties().validate();
        }
    }
}
