// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedStorageAccountsResourceInner;
import com.azure.resourcemanager.loganalytics.models.DataSourceType;

/** An instance of this class provides access to all the operations defined in LinkedStorageAccountsClient. */
public interface LinkedStorageAccountsClient {
    /**
     * Create or Update a link relation between current workspace and a group of storage accounts of a specific data
     * source type.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @param parameters The parameters required to create or update linked storage accounts.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linked storage accounts top level resource container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LinkedStorageAccountsResourceInner createOrUpdate(
        String resourceGroupName,
        String workspaceName,
        DataSourceType dataSourceType,
        LinkedStorageAccountsResourceInner parameters);

    /**
     * Create or Update a link relation between current workspace and a group of storage accounts of a specific data
     * source type.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @param parameters The parameters required to create or update linked storage accounts.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linked storage accounts top level resource container along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LinkedStorageAccountsResourceInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String workspaceName,
        DataSourceType dataSourceType,
        LinkedStorageAccountsResourceInner parameters,
        Context context);

    /**
     * Deletes all linked storage accounts of a specific data source type associated with the specified workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String workspaceName, DataSourceType dataSourceType);

    /**
     * Deletes all linked storage accounts of a specific data source type associated with the specified workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName, String workspaceName, DataSourceType dataSourceType, Context context);

    /**
     * Gets all linked storage account of a specific data source type associated with the specified workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all linked storage account of a specific data source type associated with the specified workspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LinkedStorageAccountsResourceInner get(
        String resourceGroupName, String workspaceName, DataSourceType dataSourceType);

    /**
     * Gets all linked storage account of a specific data source type associated with the specified workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param dataSourceType Linked storage accounts type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all linked storage account of a specific data source type associated with the specified workspace along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LinkedStorageAccountsResourceInner> getWithResponse(
        String resourceGroupName, String workspaceName, DataSourceType dataSourceType, Context context);

    /**
     * Gets all linked storage accounts associated with the specified workspace, storage accounts will be sorted by
     * their data source type.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all linked storage accounts associated with the specified workspace, storage accounts will be sorted by
     *     their data source type as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LinkedStorageAccountsResourceInner> listByWorkspace(String resourceGroupName, String workspaceName);

    /**
     * Gets all linked storage accounts associated with the specified workspace, storage accounts will be sorted by
     * their data source type.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all linked storage accounts associated with the specified workspace, storage accounts will be sorted by
     *     their data source type as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LinkedStorageAccountsResourceInner> listByWorkspace(
        String resourceGroupName, String workspaceName, Context context);
}
