/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyProperties;
import java.io.IOException;
import java.util.Map;

public final class ManagedHsmKeyCreateParameters
implements JsonSerializable<ManagedHsmKeyCreateParameters> {
    private Map<String, String> tags;
    private ManagedHsmKeyProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmKeyCreateParameters.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedHsmKeyCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedHsmKeyProperties properties() {
        return this.properties;
    }

    public ManagedHsmKeyCreateParameters withProperties(ManagedHsmKeyProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model ManagedHsmKeyCreateParameters"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmKeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmKeyCreateParameters)jsonReader.readObject(reader -> {
            ManagedHsmKeyCreateParameters deserializedManagedHsmKeyCreateParameters = new ManagedHsmKeyCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmKeyCreateParameters.properties = ManagedHsmKeyProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedManagedHsmKeyCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmKeyCreateParameters;
        });
    }
}

