/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionItem;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.azure.resourcemanager.keyvault.models.VaultProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class VaultProperties
implements JsonSerializable<VaultProperties> {
    private UUID tenantId;
    private Sku sku;
    private List<AccessPolicyEntry> accessPolicies;
    private String vaultUri;
    private String hsmPoolResourceId;
    private Boolean enabledForDeployment;
    private Boolean enabledForDiskEncryption;
    private Boolean enabledForTemplateDeployment;
    private Boolean enableSoftDelete;
    private Integer softDeleteRetentionInDays;
    private Boolean enableRbacAuthorization;
    private CreateMode createMode;
    private Boolean enablePurgeProtection;
    private NetworkRuleSet networkAcls;
    private VaultProvisioningState provisioningState;
    private List<PrivateEndpointConnectionItem> privateEndpointConnections;
    private String publicNetworkAccess;
    private static final ClientLogger LOGGER = new ClientLogger(VaultProperties.class);

    public UUID tenantId() {
        return this.tenantId;
    }

    public VaultProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public VaultProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<AccessPolicyEntry> accessPolicies() {
        return this.accessPolicies;
    }

    public VaultProperties withAccessPolicies(List<AccessPolicyEntry> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public String vaultUri() {
        return this.vaultUri;
    }

    public VaultProperties withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    public String hsmPoolResourceId() {
        return this.hsmPoolResourceId;
    }

    public Boolean enabledForDeployment() {
        return this.enabledForDeployment;
    }

    public VaultProperties withEnabledForDeployment(Boolean enabledForDeployment) {
        this.enabledForDeployment = enabledForDeployment;
        return this;
    }

    public Boolean enabledForDiskEncryption() {
        return this.enabledForDiskEncryption;
    }

    public VaultProperties withEnabledForDiskEncryption(Boolean enabledForDiskEncryption) {
        this.enabledForDiskEncryption = enabledForDiskEncryption;
        return this;
    }

    public Boolean enabledForTemplateDeployment() {
        return this.enabledForTemplateDeployment;
    }

    public VaultProperties withEnabledForTemplateDeployment(Boolean enabledForTemplateDeployment) {
        this.enabledForTemplateDeployment = enabledForTemplateDeployment;
        return this;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public VaultProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public VaultProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public Boolean enableRbacAuthorization() {
        return this.enableRbacAuthorization;
    }

    public VaultProperties withEnableRbacAuthorization(Boolean enableRbacAuthorization) {
        this.enableRbacAuthorization = enableRbacAuthorization;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public VaultProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public VaultProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VaultProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public VaultProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VaultProperties withProvisioningState(VaultProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<PrivateEndpointConnectionItem> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public VaultProperties withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.tenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model VaultProperties"));
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model VaultProperties"));
        }
        this.sku().validate();
        if (this.accessPolicies() != null) {
            this.accessPolicies().forEach(e -> e.validate());
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeArrayField("accessPolicies", this.accessPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("vaultUri", this.vaultUri);
        jsonWriter.writeBooleanField("enabledForDeployment", this.enabledForDeployment);
        jsonWriter.writeBooleanField("enabledForDiskEncryption", this.enabledForDiskEncryption);
        jsonWriter.writeBooleanField("enabledForTemplateDeployment", this.enabledForTemplateDeployment);
        jsonWriter.writeBooleanField("enableSoftDelete", this.enableSoftDelete);
        jsonWriter.writeNumberField("softDeleteRetentionInDays", (Number)this.softDeleteRetentionInDays);
        jsonWriter.writeBooleanField("enableRbacAuthorization", this.enableRbacAuthorization);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeBooleanField("enablePurgeProtection", this.enablePurgeProtection);
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    public static VaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VaultProperties)jsonReader.readObject(reader -> {
            VaultProperties deserializedVaultProperties = new VaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedVaultProperties.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVaultProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("accessPolicies".equals(fieldName)) {
                    List accessPolicies;
                    deserializedVaultProperties.accessPolicies = accessPolicies = reader.readArray(reader1 -> AccessPolicyEntry.fromJson(reader1));
                    continue;
                }
                if ("vaultUri".equals(fieldName)) {
                    deserializedVaultProperties.vaultUri = reader.getString();
                    continue;
                }
                if ("hsmPoolResourceId".equals(fieldName)) {
                    deserializedVaultProperties.hsmPoolResourceId = reader.getString();
                    continue;
                }
                if ("enabledForDeployment".equals(fieldName)) {
                    deserializedVaultProperties.enabledForDeployment = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledForDiskEncryption".equals(fieldName)) {
                    deserializedVaultProperties.enabledForDiskEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enabledForTemplateDeployment".equals(fieldName)) {
                    deserializedVaultProperties.enabledForTemplateDeployment = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableSoftDelete".equals(fieldName)) {
                    deserializedVaultProperties.enableSoftDelete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("softDeleteRetentionInDays".equals(fieldName)) {
                    deserializedVaultProperties.softDeleteRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableRbacAuthorization".equals(fieldName)) {
                    deserializedVaultProperties.enableRbacAuthorization = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedVaultProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("enablePurgeProtection".equals(fieldName)) {
                    deserializedVaultProperties.enablePurgeProtection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedVaultProperties.networkAcls = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVaultProperties.provisioningState = VaultProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedVaultProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionItem.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedVaultProperties.publicNetworkAccess = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultProperties;
        });
    }
}

