/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.VaultsClient;
import com.azure.resourcemanager.keyvault.fluent.models.DeletedVaultInner;
import com.azure.resourcemanager.keyvault.fluent.models.VaultInner;
import com.azure.resourcemanager.keyvault.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.keyvault.implementation.DeletedVaultImpl;
import com.azure.resourcemanager.keyvault.implementation.VaultImpl;
import com.azure.resourcemanager.keyvault.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.DeletedVault;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.azure.resourcemanager.keyvault.models.SkuFamily;
import com.azure.resourcemanager.keyvault.models.SkuName;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.keyvault.models.VaultCreateOrUpdateParameters;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import com.azure.resourcemanager.keyvault.models.Vaults;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class VaultsImpl
extends GroupableResourcesImpl<Vault, VaultImpl, VaultInner, VaultsClient, KeyVaultManager>
implements Vaults {
    private final AuthorizationManager authorizationManager;
    private final String tenantId;

    public VaultsImpl(KeyVaultManager keyVaultManager, AuthorizationManager authorizationManager, String tenantId) {
        super((Object)((KeyVaultManagementClient)keyVaultManager.serviceClient()).getVaults(), (Manager)keyVaultManager);
        this.authorizationManager = authorizationManager;
        this.tenantId = tenantId;
    }

    public PagedIterable<Vault> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<Vault> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((VaultsClient)this.inner()).listByResourceGroupAsync(resourceGroupName, null));
    }

    protected Mono<VaultInner> getInnerAsync(String resourceGroupName, String name) {
        return ((VaultsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((VaultsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    public Mono<Void> deleteByResourceGroupAsync(String groupName, String name) {
        return ((VaultsClient)this.inner()).deleteAsync(groupName, name);
    }

    public VaultImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD).withEmptyAccessPolicy();
    }

    protected VaultImpl wrapModel(String name) {
        VaultInner inner = new VaultInner().withProperties(new VaultProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new VaultImpl(name, inner, (KeyVaultManager)this.manager(), this.authorizationManager);
    }

    protected VaultImpl wrapModel(VaultInner vaultInner) {
        if (vaultInner == null) {
            return null;
        }
        return new VaultImpl(vaultInner.name(), vaultInner, (KeyVaultManager)this.manager(), this.authorizationManager);
    }

    @Override
    public PagedIterable<DeletedVault> listDeleted() {
        return PagedConverter.mapPage(((VaultsClient)this.inner()).listDeleted(), DeletedVaultImpl::new);
    }

    @Override
    public DeletedVault getDeleted(String vaultName, String location) {
        DeletedVaultInner deletedVault = ((VaultsClient)this.inner()).getDeleted(vaultName, location);
        if (deletedVault == null) {
            return null;
        }
        return new DeletedVaultImpl(deletedVault);
    }

    @Override
    public void purgeDeleted(String vaultName, String location) {
        ((VaultsClient)this.inner()).purgeDeleted(vaultName, location);
    }

    @Override
    public Mono<DeletedVault> getDeletedAsync(String vaultName, String location) {
        return ((VaultsClient)this.inner()).getDeletedAsync(vaultName, location).map(DeletedVaultImpl::new);
    }

    @Override
    public Mono<Void> purgeDeletedAsync(String vaultName, String location) {
        return ((VaultsClient)this.inner()).purgeDeletedAsync(vaultName, location);
    }

    @Override
    public PagedFlux<DeletedVault> listDeletedAsync() {
        return PagedConverter.mapPage(((VaultsClient)this.inner()).listDeletedAsync(), DeletedVaultImpl::new);
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((VaultsClient)this.inner()).checkNameAvailability(name));
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((VaultsClient)this.inner()).checkNameAvailabilityAsync(name).map(CheckNameAvailabilityResultImpl::new);
    }

    @Override
    public Vault recoverSoftDeletedVault(String resourceGroupName, String vaultName, String location) {
        return (Vault)this.recoverSoftDeletedVaultAsync(resourceGroupName, vaultName, location).block();
    }

    @Override
    public Mono<Vault> recoverSoftDeletedVaultAsync(String resourceGroupName, String vaultName, String location) {
        KeyVaultManager manager = (KeyVaultManager)this.manager();
        return this.getDeletedAsync(vaultName, location).flatMap(deletedVault -> {
            VaultCreateOrUpdateParameters parameters = new VaultCreateOrUpdateParameters();
            parameters.withLocation(deletedVault.location());
            parameters.withTags(((DeletedVaultInner)deletedVault.innerModel()).properties().tags());
            parameters.withProperties(new VaultProperties().withCreateMode(CreateMode.RECOVER).withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.A)).withTenantId(UUID.fromString(this.tenantId)));
            return ((VaultsClient)this.inner()).createOrUpdateAsync(resourceGroupName, vaultName, parameters).map(inner -> new VaultImpl(inner.id(), (VaultInner)((Object)((Object)inner)), manager, this.authorizationManager));
        });
    }
}

