/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.BinaryHardeningSummaryResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoCertificateSummaryResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoKeySummaryResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveSummary;
import com.azure.resourcemanager.iotfirmwaredefense.models.FirmwareSummary;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public class SummaryResourceProperties
implements JsonSerializable<SummaryResourceProperties> {
    private SummaryType summaryType = SummaryType.fromString("SummaryResourceProperties");
    private ProvisioningState provisioningState;

    protected SummaryResourceProperties() {
    }

    public SummaryType summaryType() {
        return this.summaryType;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    SummaryResourceProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SummaryResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SummaryResourceProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                SummaryResourceProperties summaryResourceProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("summaryType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Firmware".equals(discriminatorValue)) {
                    summaryResourceProperties = FirmwareSummary.fromJson(readerToUse.reset());
                    return summaryResourceProperties;
                }
                if ("CommonVulnerabilitiesAndExposures".equals(discriminatorValue)) {
                    summaryResourceProperties = CveSummary.fromJson(readerToUse.reset());
                    return summaryResourceProperties;
                }
                if ("BinaryHardening".equals(discriminatorValue)) {
                    summaryResourceProperties = BinaryHardeningSummaryResource.fromJson(readerToUse.reset());
                    return summaryResourceProperties;
                }
                if ("CryptoCertificate".equals(discriminatorValue)) {
                    summaryResourceProperties = CryptoCertificateSummaryResource.fromJson(readerToUse.reset());
                    return summaryResourceProperties;
                }
                if ("CryptoKey".equals(discriminatorValue)) {
                    summaryResourceProperties = CryptoKeySummaryResource.fromJson(readerToUse.reset());
                    return summaryResourceProperties;
                }
                summaryResourceProperties = SummaryResourceProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return summaryResourceProperties;
            }
        });
    }

    static SummaryResourceProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (SummaryResourceProperties)jsonReader.readObject(reader -> {
            SummaryResourceProperties deserializedSummaryResourceProperties = new SummaryResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("summaryType".equals(fieldName)) {
                    deserializedSummaryResourceProperties.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSummaryResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSummaryResourceProperties;
        });
    }
}

